"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineOverviewLogic = void 0;
var _kea = require("kea");
var _flash_messages = require("../../../shared/flash_messages");
var _http = require("../../../shared/http");
var _engine = require("../engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EngineOverviewLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'app_search', 'engine_overview_logic'],
  actions: () => ({
    loadOverviewMetrics: true,
    onOverviewMetricsLoad: engineMetrics => engineMetrics
  }),
  reducers: () => ({
    dataLoading: [true, {
      onOverviewMetricsLoad: () => false
    }],
    startDate: ['', {
      onOverviewMetricsLoad: (_, {
        startDate
      }) => startDate
    }],
    queriesPerDay: [[], {
      onOverviewMetricsLoad: (_, {
        queriesPerDay
      }) => queriesPerDay
    }],
    operationsPerDay: [[], {
      onOverviewMetricsLoad: (_, {
        operationsPerDay
      }) => operationsPerDay
    }],
    totalQueries: [0, {
      onOverviewMetricsLoad: (_, {
        totalQueries
      }) => totalQueries
    }],
    totalClicks: [0, {
      onOverviewMetricsLoad: (_, {
        totalClicks
      }) => totalClicks
    }],
    documentCount: [0, {
      onOverviewMetricsLoad: (_, {
        documentCount
      }) => documentCount
    }]
  }),
  listeners: ({
    actions
  }) => ({
    loadOverviewMetrics: async () => {
      const {
        http
      } = _http.HttpLogic.values;
      const {
        engineName
      } = _engine.EngineLogic.values;
      try {
        const response = await http.get(`/internal/app_search/engines/${engineName}/overview`);
        actions.onOverviewMetricsLoad(response);
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    }
  })
});
exports.EngineOverviewLogic = EngineOverviewLogic;