"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActiveQuerySelect = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _curation_logic = require("../curation_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActiveQuerySelect = () => {
  const {
    setActiveQuery
  } = (0, _kea.useActions)(_curation_logic.CurationLogic);
  const {
    queries,
    activeQuery,
    queriesLoading
  } = (0, _kea.useValues)(_curation_logic.CurationLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.activeQueryLabel', {
      defaultMessage: 'Active query'
    }),
    helpText: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.activeQueryHelpText', {
      defaultMessage: 'Select a query to view the organic search results for them'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: queries.map(query => ({
      value: query,
      text: query
    })),
    value: activeQuery,
    onChange: e => setActiveQuery(e.target.value),
    isLoading: queriesLoading,
    fullWidth: true
  }));
};
exports.ActiveQuerySelect = ActiveQuerySelect;