"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlerOverview = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _routes = require("../../routes");
var _engine = require("../engine");
var _layout = require("../layout");
var _add_domain_flyout = require("./components/add_domain/add_domain_flyout");
var _add_domain_form = require("./components/add_domain/add_domain_form");
var _add_domain_form_errors = require("./components/add_domain/add_domain_form_errors");
var _add_domain_form_submit_button = require("./components/add_domain/add_domain_form_submit_button");
var _add_domain_logic = require("./components/add_domain/add_domain_logic");
var _crawl_custom_settings_flyout = require("./components/crawl_custom_settings_flyout/crawl_custom_settings_flyout");
var _crawl_details_flyout = require("./components/crawl_details_flyout");
var _crawl_requests_table = require("./components/crawl_requests_table");
var _crawl_select_domains_modal = require("./components/crawl_select_domains_modal/crawl_select_domains_modal");
var _crawler_status_banner = require("./components/crawler_status_banner");
var _crawler_status_indicator = require("./components/crawler_status_indicator/crawler_status_indicator");
var _domains_table = require("./components/domains_table");
var _manage_crawls_popover = require("./components/manage_crawls_popover/manage_crawls_popover");
var _constants = require("./constants");
var _crawler_logic = require("./crawler_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlerOverview = () => {
  const {
    events,
    dataLoading,
    domains
  } = (0, _kea.useValues)(_crawler_logic.CrawlerLogic);
  const {
    errors: addDomainErrors
  } = (0, _kea.useValues)(_add_domain_logic.AddDomainLogic);
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: (0, _engine.getEngineBreadcrumbs)([_constants.CRAWLER_TITLE]),
    pageHeader: {
      pageTitle: _constants.CRAWLER_TITLE,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_manage_crawls_popover.ManageCrawlsPopover, null), /*#__PURE__*/_react.default.createElement(_crawler_status_indicator.CrawlerStatusIndicator, null)]
    },
    isLoading: dataLoading
  }, /*#__PURE__*/_react.default.createElement(_crawler_status_banner.CrawlerStatusBanner, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), domains.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "stretch"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.domainsTitle', {
    defaultMessage: 'Domains'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_add_domain_flyout.AddDomainFlyout, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_domains_table.DomainsTable, null)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.empty.title', {
    defaultMessage: 'Add a domain to get started'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.empty.description', {
    defaultMessage: "Easily index your website's content. To get started, enter your domain name, provide optional entry points and crawl rules, and we will handle the rest."
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    external: true,
    target: "_blank",
    href: _routes.WEB_CRAWLER_DOCS_URL
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.empty.crawlerDocumentationLinkDescription', {
    defaultMessage: 'Learn more about the web crawler'
  })))), addDomainErrors && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_add_domain_form_errors.AddDomainFormErrors, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_add_domain_form.AddDomainForm, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_add_domain_form_submit_button.AddDomainFormSubmitButton, null)))), (events.length > 0 || domains.length > 0) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlRequestsTitle', {
    defaultMessage: 'Recent crawl requests'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlRequestsDescription', {
    defaultMessage: "Recent crawl requests are logged here. Using the request ID of each crawl, you can track progress and examine crawl events in Kibana's Discover or Logs user interfaces."
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _routes.WEB_CRAWLER_LOG_DOCS_URL,
    target: "_blank",
    external: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.configurationDocumentationLinkDescription', {
    defaultMessage: 'Learn more about configuring crawler logs in Kibana'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_crawl_requests_table.CrawlRequestsTable, null)), /*#__PURE__*/_react.default.createElement(_crawl_details_flyout.CrawlDetailsFlyout, null), /*#__PURE__*/_react.default.createElement(_crawl_select_domains_modal.CrawlSelectDomainsModal, null), /*#__PURE__*/_react.default.createElement(_crawl_custom_settings_flyout.CrawlCustomSettingsFlyout, null));
};
exports.CrawlerOverview = CrawlerOverview;