"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFormulaByFilter = exports.FilterBy = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let FilterBy;
exports.FilterBy = FilterBy;
(function (FilterBy) {
  FilterBy["Searches"] = "Searches";
  FilterBy["NoResults"] = "NoResults";
  FilterBy["Clicks"] = "Clicks";
  FilterBy["Sessions"] = "Sessions";
})(FilterBy || (exports.FilterBy = FilterBy = {}));
const getFormulaByFilter = (filter, shift) => {
  const mapFilterByToFormula = {
    [FilterBy.Searches]: "count(search.query, kql='event.action: search'",
    [FilterBy.NoResults]: "count(kql='search.results.total_results : 0 and event.action: search'",
    [FilterBy.Clicks]: "count(kql='event.action: search_click'",
    [FilterBy.Sessions]: 'unique_count(session.id'
  };
  return mapFilterByToFormula[filter] + (shift ? `, shift='${shift}'` : '') + ')';
};
exports.getFormulaByFilter = getFormulaByFilter;