"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SemanticSearchSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _elser = _interopRequireDefault(require("../../../../assets/images/elser.svg"));
var _nlp = _interopRequireDefault(require("../../../../assets/images/nlp.svg"));
var _vector = _interopRequireDefault(require("../../../../assets/images/vector.svg"));
var _ai_search_guide_accordion = require("./ai_search_guide_accordion");
var _elser_panel = require("./elser_panel");
var _nlp_enrichment_panel = require("./nlp_enrichment_panel");
var _vector_search_panel = require("./vector_search_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SemanticSearchSection = () => {
  const [currentExpandedId, setCurrentExpandedId] = (0, _react.useState)('elserAccordion');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.aiSearch.semanticSearch.title",
    defaultMessage: "Set up semantic search"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.aiSearch.semanticSearch.description",
    defaultMessage: "Combine any of these information retrieval tools."
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_ai_search_guide_accordion.AISearchGuideAccordion, {
    id: "elserAccordion",
    "data-telemetry-id": "entSearch-aiSearch-semanticSearch-elserAccordion",
    initialIsOpen: true,
    icon: _elser.default,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.elserAccordion.title', {
      defaultMessage: 'Elastic Learned Sparse Encoder'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.elserAccordion.description', {
      defaultMessage: 'Instant semantic search capabilities'
    }),
    currentExpandedId: currentExpandedId,
    onToggle: setCurrentExpandedId
  }, /*#__PURE__*/_react.default.createElement(_elser_panel.ElserPanel, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_ai_search_guide_accordion.AISearchGuideAccordion, {
    id: "vectorSearchAccordion",
    "data-telemetry-id": "entSearch-aiSearch-semanticSearch-vectorSearchAccordion",
    icon: _vector.default,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.vectorSearchAccordion.title', {
      defaultMessage: 'Vector Search'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.vectorSearchAccordion.description', {
      defaultMessage: 'Powerful similarity searches for unstructured data'
    }),
    currentExpandedId: currentExpandedId,
    onToggle: setCurrentExpandedId
  }, /*#__PURE__*/_react.default.createElement(_vector_search_panel.VectorSearchPanel, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_ai_search_guide_accordion.AISearchGuideAccordion, {
    id: "nlpEnrichmentAccordion",
    "data-telemetry-id": "entSearch-aiSearch-semanticSearch-nlpEnrichmentAccordion",
    icon: _nlp.default,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.nlpEnrichmentAccordion.title', {
      defaultMessage: 'NLP Enrichment'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.nlpEnrichmentAccordion.description', {
      defaultMessage: 'Insightful data enrichment with trained ML models'
    }),
    currentExpandedId: currentExpandedId,
    onToggle: setCurrentExpandedId
  }, /*#__PURE__*/_react.default.createElement(_nlp_enrichment_panel.NlpEnrichmentPanel, null))))));
};
exports.SemanticSearchSection = SemanticSearchSection;