"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElserPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _routes = require("../../../enterprise_search_content/routes");
var _doc_links = require("../../../shared/doc_links");
var _react_router_helpers = require("../../../shared/react_router_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const steps = [{
  title: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.elserPanel.step1.title', {
    defaultMessage: 'Create an index'
  }),
  children: /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    to: (0, _reactRouterDom.generatePath)(_constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.URL + _routes.NEW_INDEX_PATH),
    shouldNotCreateHref: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearch-aiSearch-semanticSearch-elserPanel-createIndexButton",
    iconType: "plusInCircle"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.elserPanel.step1.buttonLabel', {
    defaultMessage: 'Create an index'
  }))),
  status: 'incomplete'
}, {
  title: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.elserPanel.step2.title', {
    defaultMessage: "Navigate to index's Pipelines tab"
  }),
  children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.aiSearch.elserPanel.step2.description",
    defaultMessage: "After creating an index, select it and click the tab called {pipelinesName}.",
    values: {
      pipelinesName: /*#__PURE__*/_react.default.createElement("strong", null, "\"", _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.elserPanel.step2.description.pipelinesName', {
        defaultMessage: 'Pipelines'
      }), "\"")
    }
  }))),
  status: 'incomplete'
}, {
  title: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.elserPanel.step3.title', {
    defaultMessage: 'Follow the on-screen instructions to deploy ELSER'
  }),
  children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.aiSearch.elserPanel.step3.description",
    defaultMessage: "Locate the panel that allows you to one click deploy ELSER and create an inference pipeline using that model."
  }))),
  status: 'incomplete'
}];
const ElserPanel = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.aiSearch.elser.description",
  defaultMessage: "Effortlessly deploy the {elser} for instant text semantic search capabilities in just a few clicks. This model expands your document and query text using the 'text_expansion' field, delivering seamless search out of the box.",
  values: {
    elser: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      target: "_blank",
      href: _doc_links.docLinks.elser,
      external: false
    }, _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.elser.description.elserLinkText', {
      defaultMessage: 'Elastic Learned Sparse Encoder v2'
    }))
  }
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
  steps: steps,
  titleSize: "xs"
}))));
exports.ElserPanel = ElserPanel;