"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.crawlerStatusToSyncStatus = exports.crawlerStatusToConnectorStatus = exports.CrawlerStatus = void 0;
var _searchConnectors = require("@kbn/search-connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// See SharedTogo::Crawler::Status for details on how these are generated
let CrawlerStatus;
exports.CrawlerStatus = CrawlerStatus;
(function (CrawlerStatus) {
  CrawlerStatus["Pending"] = "pending";
  CrawlerStatus["Suspended"] = "suspended";
  CrawlerStatus["Starting"] = "starting";
  CrawlerStatus["Running"] = "running";
  CrawlerStatus["Suspending"] = "suspending";
  CrawlerStatus["Canceling"] = "canceling";
  CrawlerStatus["Success"] = "success";
  CrawlerStatus["Failed"] = "failed";
  CrawlerStatus["Canceled"] = "canceled";
  CrawlerStatus["Skipped"] = "skipped";
})(CrawlerStatus || (exports.CrawlerStatus = CrawlerStatus = {}));
const crawlerStatusSyncMap = {
  [CrawlerStatus.Canceling]: _searchConnectors.SyncStatus.CANCELING,
  [CrawlerStatus.Canceled]: _searchConnectors.SyncStatus.CANCELED,
  [CrawlerStatus.Failed]: _searchConnectors.SyncStatus.ERROR,
  [CrawlerStatus.Pending]: _searchConnectors.SyncStatus.PENDING,
  [CrawlerStatus.Running]: _searchConnectors.SyncStatus.IN_PROGRESS,
  [CrawlerStatus.Skipped]: _searchConnectors.SyncStatus.CANCELED,
  [CrawlerStatus.Starting]: _searchConnectors.SyncStatus.PENDING,
  [CrawlerStatus.Success]: _searchConnectors.SyncStatus.COMPLETED,
  [CrawlerStatus.Suspended]: _searchConnectors.SyncStatus.SUSPENDED,
  [CrawlerStatus.Suspending]: _searchConnectors.SyncStatus.IN_PROGRESS
};
const crawlerStatusConnectorStatusMap = {
  [CrawlerStatus.Canceling]: _searchConnectors.ConnectorStatus.CONNECTED,
  [CrawlerStatus.Canceled]: _searchConnectors.ConnectorStatus.CONNECTED,
  [CrawlerStatus.Failed]: _searchConnectors.ConnectorStatus.ERROR,
  [CrawlerStatus.Pending]: _searchConnectors.ConnectorStatus.CONNECTED,
  [CrawlerStatus.Running]: _searchConnectors.ConnectorStatus.CONNECTED,
  [CrawlerStatus.Skipped]: _searchConnectors.ConnectorStatus.CONNECTED,
  [CrawlerStatus.Starting]: _searchConnectors.ConnectorStatus.CONNECTED,
  [CrawlerStatus.Success]: _searchConnectors.ConnectorStatus.CONNECTED,
  [CrawlerStatus.Suspended]: _searchConnectors.ConnectorStatus.CONNECTED,
  [CrawlerStatus.Suspending]: _searchConnectors.ConnectorStatus.CONNECTED
};
const crawlerStatusToSyncStatus = crawlerStatus => {
  return crawlerStatusSyncMap[crawlerStatus];
};
exports.crawlerStatusToSyncStatus = crawlerStatusToSyncStatus;
const crawlerStatusToConnectorStatus = crawlerStatus => {
  return crawlerStatusConnectorStatusMap[crawlerStatus];
};
exports.crawlerStatusToConnectorStatus = crawlerStatusToConnectorStatus;