"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultConnectorsPipelineMeta = exports.WORKPLACE_SEARCH_URL = exports.WORKPLACE_SEARCH_PLUGIN = exports.VECTOR_SEARCH_PLUGIN = exports.SEARCH_PRODUCT_NAME = exports.SEARCH_EXPERIENCES_PLUGIN = exports.READ_ONLY_MODE_HEADER = exports.PLUGIN_ID = exports.LICENSED_SUPPORT_URL = exports.JSON_HEADER = exports.INGESTION_METHOD_IDS = exports.ERROR_CONNECTING_HEADER = exports.ENTERPRISE_SEARCH_RELEVANCE_LOGS_SOURCE_ID = exports.ENTERPRISE_SEARCH_PRODUCT_NAME = exports.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN = exports.ENTERPRISE_SEARCH_KIBANA_COOKIE = exports.ENTERPRISE_SEARCH_ELASTICSEARCH_URL = exports.ENTERPRISE_SEARCH_DOCUMENTS_DEFAULT_DOC_COUNT = exports.ENTERPRISE_SEARCH_CONTENT_PLUGIN = exports.ENTERPRISE_SEARCH_CONNECTOR_CRAWLER_SERVICE_TYPE = exports.ENTERPRISE_SEARCH_AUDIT_LOGS_SOURCE_ID = exports.ENTERPRISE_SEARCH_ANALYTICS_LOGS_SOURCE_ID = exports.ELASTICSEARCH_PLUGIN = exports.DEFAULT_PRODUCT_FEATURES = exports.DEFAULT_PIPELINE_VALUES = exports.DEFAULT_PIPELINE_NAME = exports.CONNECTOR_NATIVE_TYPE = exports.CONNECTOR_CLIENTS_TYPE = exports.CONNECTORS_ACCESS_CONTROL_INDEX_PREFIX = exports.APP_SEARCH_URL = exports.APP_SEARCH_PLUGIN = exports.APPLICATIONS_PLUGIN = exports.ANALYTICS_PLUGIN = exports.AI_SEARCH_PLUGIN = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SEARCH_PRODUCT_NAME = _i18n.i18n.translate('xpack.enterpriseSearch.search.productName', {
  defaultMessage: 'Search'
});
exports.SEARCH_PRODUCT_NAME = SEARCH_PRODUCT_NAME;
const ENTERPRISE_SEARCH_PRODUCT_NAME = _i18n.i18n.translate('xpack.enterpriseSearch.productName', {
  defaultMessage: 'Enterprise Search'
});
exports.ENTERPRISE_SEARCH_PRODUCT_NAME = ENTERPRISE_SEARCH_PRODUCT_NAME;
const ENTERPRISE_SEARCH_OVERVIEW_PLUGIN = {
  ID: 'enterpriseSearch',
  NAME: SEARCH_PRODUCT_NAME,
  NAV_TITLE: _i18n.i18n.translate('xpack.enterpriseSearch.overview.navTitle', {
    defaultMessage: 'Overview'
  }),
  DESCRIPTION: _i18n.i18n.translate('xpack.enterpriseSearch.overview.description', {
    defaultMessage: 'Create search experiences with a refined set of APIs and tools.'
  }),
  URL: '/app/enterprise_search/overview',
  LOGO: 'logoEnterpriseSearch'
};
exports.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN = ENTERPRISE_SEARCH_OVERVIEW_PLUGIN;
const ENTERPRISE_SEARCH_CONTENT_PLUGIN = {
  ID: 'enterpriseSearchContent',
  NAME: SEARCH_PRODUCT_NAME,
  NAV_TITLE: _i18n.i18n.translate('xpack.enterpriseSearch.content.navTitle', {
    defaultMessage: 'Content'
  }),
  DESCRIPTION: _i18n.i18n.translate('xpack.enterpriseSearch.content.description', {
    defaultMessage: 'Enterprise search offers a number of ways to easily make your data searchable. Choose from the web crawler, Elasticsearch indices, API, direct uploads, or thrid party connectors.' // TODO: Make sure this content is correct.
  }),

  URL: '/app/enterprise_search/content',
  LOGO: 'logoEnterpriseSearch',
  SUPPORT_URL: 'https://discuss.elastic.co/c/enterprise-search/'
};
exports.ENTERPRISE_SEARCH_CONTENT_PLUGIN = ENTERPRISE_SEARCH_CONTENT_PLUGIN;
const AI_SEARCH_PLUGIN = {
  ID: 'enterpriseSearchAISearch',
  NAME: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.productName', {
    defaultMessage: 'AI Search'
  }),
  NAV_TITLE: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.navTitle', {
    defaultMessage: 'AI Search'
  }),
  DESCRIPTION: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.description', {
    defaultMessage: 'Toolkit for enabling developers to build AI search-powered applications using the Elastic platform.'
  }),
  URL: '/app/enterprise_search/ai_search',
  LOGO: 'logoEnterpriseSearch'
};
exports.AI_SEARCH_PLUGIN = AI_SEARCH_PLUGIN;
const ANALYTICS_PLUGIN = {
  ID: 'enterpriseSearchAnalytics',
  NAME: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.productName', {
    defaultMessage: 'Behavioral Analytics'
  }),
  DESCRIPTION: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.productDescription', {
    defaultMessage: 'Dashboards and tools for visualizing end-user behavior and measuring the performance of your search applications.'
  }),
  CARD_DESCRIPTION: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.productCardDescription', {
    defaultMessage: 'Dashboards and tools for visualizing end-user behavior and measuring the performance of your search applications.'
  }),
  URL: '/app/enterprise_search/analytics',
  SUPPORT_URL: 'https://discuss.elastic.co/c/enterprise-search/'
};
exports.ANALYTICS_PLUGIN = ANALYTICS_PLUGIN;
const ELASTICSEARCH_PLUGIN = {
  ID: 'enterpriseSearchElasticsearch',
  NAME: _i18n.i18n.translate('xpack.enterpriseSearch.elasticsearch.productName', {
    defaultMessage: 'Elasticsearch'
  }),
  DESCRIPTION: _i18n.i18n.translate('xpack.enterpriseSearch.elasticsearch.productDescription', {
    defaultMessage: 'Low-level tools for creating performant and relevant search experiences.'
  }),
  URL: '/app/enterprise_search/elasticsearch',
  SUPPORT_URL: 'https://discuss.elastic.co/c/elastic-stack/elasticsearch/'
};
exports.ELASTICSEARCH_PLUGIN = ELASTICSEARCH_PLUGIN;
const APP_SEARCH_PLUGIN = {
  ID: 'appSearch',
  NAME: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.productName', {
    defaultMessage: 'App Search'
  }),
  DESCRIPTION: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.productDescription', {
    defaultMessage: 'Leverage dashboards, analytics, and APIs for advanced application search made simple.'
  }),
  URL: '/app/enterprise_search/app_search',
  SUPPORT_URL: 'https://discuss.elastic.co/c/enterprise-search/app-search/'
};
exports.APP_SEARCH_PLUGIN = APP_SEARCH_PLUGIN;
const WORKPLACE_SEARCH_PLUGIN = {
  ID: 'workplaceSearch',
  NAME: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.productName', {
    defaultMessage: 'Workplace Search'
  }),
  DESCRIPTION: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.productDescription', {
    defaultMessage: 'Search all documents, files, and sources available across your virtual workplace.'
  }),
  URL: '/app/enterprise_search/workplace_search',
  NON_ADMIN_URL: '/app/enterprise_search/workplace_search/p',
  SUPPORT_URL: 'https://discuss.elastic.co/c/enterprise-search/workplace-search/'
};
exports.WORKPLACE_SEARCH_PLUGIN = WORKPLACE_SEARCH_PLUGIN;
const SEARCH_EXPERIENCES_PLUGIN = {
  ID: 'searchExperiences',
  NAME: _i18n.i18n.translate('xpack.enterpriseSearch.searchExperiences.productName', {
    defaultMessage: 'Search Experiences'
  }),
  NAV_TITLE: _i18n.i18n.translate('xpack.enterpriseSearch.searchExperiences.navTitle', {
    defaultMessage: 'Search Experiences'
  }),
  DESCRIPTION: _i18n.i18n.translate('xpack.enterpriseSearch.searchExperiences.productDescription', {
    defaultMessage: 'Build an intuitive, engaging search experience without reinventing the wheel.'
  }),
  URL: '/app/enterprise_search/search_experiences',
  SUPPORT_URL: 'https://discuss.elastic.co/c/enterprise-search/',
  GITHUB_URL: 'https://github.com/elastic/search-ui/',
  DOCUMENTATION_URL: 'https://docs.elastic.co/search-ui/',
  ELASTICSEARCH_TUTORIAL_URL: 'https://docs.elastic.co/search-ui/tutorials/elasticsearch',
  APP_SEARCH_TUTORIAL_URL: 'https://docs.elastic.co/search-ui/tutorials/app-search',
  WORKPLACE_SEARCH_TUTORIAL_URL: 'https://docs.elastic.co/search-ui/tutorials/workplace-search'
};
exports.SEARCH_EXPERIENCES_PLUGIN = SEARCH_EXPERIENCES_PLUGIN;
const APPLICATIONS_PLUGIN = {
  ID: 'enterpriseSearchApplications',
  LOGO: 'logoEnterpriseSearch',
  NAME: _i18n.i18n.translate('xpack.enterpriseSearch.applications.productName', {
    defaultMessage: 'Applications'
  }),
  NAV_TITLE: _i18n.i18n.translate('xpack.enterpriseSearch.applications.navTitle', {
    defaultMessage: 'Search Applications'
  }),
  SUPPORT_URL: 'https://discuss.elastic.co/c/enterprise-search/',
  URL: '/app/enterprise_search/applications'
};
exports.APPLICATIONS_PLUGIN = APPLICATIONS_PLUGIN;
const VECTOR_SEARCH_PLUGIN = {
  DESCRIPTION: _i18n.i18n.translate('xpack.enterpriseSearch.vectorSearch.description', {
    defaultMessage: 'Elasticsearch can be used as a vector database, which enables vector search and semantic search use cases.'
  }),
  ID: 'enterpriseSearchVectorSearch',
  LOGO: 'logoEnterpriseSearch',
  NAME: _i18n.i18n.translate('xpack.enterpriseSearch.vectorSearch.productName', {
    defaultMessage: 'Vector Search'
  }),
  NAV_TITLE: _i18n.i18n.translate('xpack.enterpriseSearch.vectorSearch.navTitle', {
    defaultMessage: 'Vector Search'
  }),
  SUPPORT_URL: 'https://discuss.elastic.co/c/enterprise-search/',
  URL: '/app/enterprise_search/vector_search'
};
exports.VECTOR_SEARCH_PLUGIN = VECTOR_SEARCH_PLUGIN;
const LICENSED_SUPPORT_URL = 'https://support.elastic.co';
exports.LICENSED_SUPPORT_URL = LICENSED_SUPPORT_URL;
const JSON_HEADER = {
  'Content-Type': 'application/json',
  // This needs specific casing or Chrome throws a 415 error
  Accept: 'application/json' // Required for Enterprise Search APIs
};
exports.JSON_HEADER = JSON_HEADER;
const ERROR_CONNECTING_HEADER = 'x-ent-search-error-connecting';
exports.ERROR_CONNECTING_HEADER = ERROR_CONNECTING_HEADER;
const READ_ONLY_MODE_HEADER = 'x-ent-search-read-only-mode';
exports.READ_ONLY_MODE_HEADER = READ_ONLY_MODE_HEADER;
const ENTERPRISE_SEARCH_KIBANA_COOKIE = '_enterprise_search';
exports.ENTERPRISE_SEARCH_KIBANA_COOKIE = ENTERPRISE_SEARCH_KIBANA_COOKIE;
const ENTERPRISE_SEARCH_RELEVANCE_LOGS_SOURCE_ID = 'ent-search-logs';
exports.ENTERPRISE_SEARCH_RELEVANCE_LOGS_SOURCE_ID = ENTERPRISE_SEARCH_RELEVANCE_LOGS_SOURCE_ID;
const ENTERPRISE_SEARCH_AUDIT_LOGS_SOURCE_ID = 'ent-search-audit-logs';
exports.ENTERPRISE_SEARCH_AUDIT_LOGS_SOURCE_ID = ENTERPRISE_SEARCH_AUDIT_LOGS_SOURCE_ID;
const ENTERPRISE_SEARCH_ANALYTICS_LOGS_SOURCE_ID = 'ent-search-analytics-logs';
exports.ENTERPRISE_SEARCH_ANALYTICS_LOGS_SOURCE_ID = ENTERPRISE_SEARCH_ANALYTICS_LOGS_SOURCE_ID;
const APP_SEARCH_URL = '/app/enterprise_search/app_search';
exports.APP_SEARCH_URL = APP_SEARCH_URL;
const ENTERPRISE_SEARCH_ELASTICSEARCH_URL = '/app/enterprise_search/elasticsearch';
exports.ENTERPRISE_SEARCH_ELASTICSEARCH_URL = ENTERPRISE_SEARCH_ELASTICSEARCH_URL;
const WORKPLACE_SEARCH_URL = '/app/enterprise_search/workplace_search';
exports.WORKPLACE_SEARCH_URL = WORKPLACE_SEARCH_URL;
const ENTERPRISE_SEARCH_DOCUMENTS_DEFAULT_DOC_COUNT = 25;
exports.ENTERPRISE_SEARCH_DOCUMENTS_DEFAULT_DOC_COUNT = ENTERPRISE_SEARCH_DOCUMENTS_DEFAULT_DOC_COUNT;
const ENTERPRISE_SEARCH_CONNECTOR_CRAWLER_SERVICE_TYPE = 'elastic-crawler';
exports.ENTERPRISE_SEARCH_CONNECTOR_CRAWLER_SERVICE_TYPE = ENTERPRISE_SEARCH_CONNECTOR_CRAWLER_SERVICE_TYPE;
const DEFAULT_PIPELINE_NAME = 'ent-search-generic-ingestion';
exports.DEFAULT_PIPELINE_NAME = DEFAULT_PIPELINE_NAME;
const DEFAULT_PIPELINE_VALUES = {
  extract_binary_content: true,
  name: DEFAULT_PIPELINE_NAME,
  reduce_whitespace: true,
  run_ml_inference: true
};
exports.DEFAULT_PIPELINE_VALUES = DEFAULT_PIPELINE_VALUES;
const defaultConnectorsPipelineMeta = {
  default_extract_binary_content: DEFAULT_PIPELINE_VALUES.extract_binary_content,
  default_name: DEFAULT_PIPELINE_NAME,
  default_reduce_whitespace: DEFAULT_PIPELINE_VALUES.reduce_whitespace,
  default_run_ml_inference: DEFAULT_PIPELINE_VALUES.run_ml_inference
};
exports.defaultConnectorsPipelineMeta = defaultConnectorsPipelineMeta;
let INGESTION_METHOD_IDS;
exports.INGESTION_METHOD_IDS = INGESTION_METHOD_IDS;
(function (INGESTION_METHOD_IDS) {
  INGESTION_METHOD_IDS["API"] = "api";
  INGESTION_METHOD_IDS["CONNECTOR"] = "connector";
  INGESTION_METHOD_IDS["CRAWLER"] = "crawler";
})(INGESTION_METHOD_IDS || (exports.INGESTION_METHOD_IDS = INGESTION_METHOD_IDS = {}));
const DEFAULT_PRODUCT_FEATURES = {
  hasConnectors: true,
  hasDefaultIngestPipeline: true,
  hasDocumentLevelSecurityEnabled: true,
  hasIncrementalSyncEnabled: true,
  hasNativeConnectors: true,
  hasWebCrawler: true
};
exports.DEFAULT_PRODUCT_FEATURES = DEFAULT_PRODUCT_FEATURES;
const CONNECTORS_ACCESS_CONTROL_INDEX_PREFIX = '.search-acl-filter-';
exports.CONNECTORS_ACCESS_CONTROL_INDEX_PREFIX = CONNECTORS_ACCESS_CONTROL_INDEX_PREFIX;
const PLUGIN_ID = 'enterpriseSearch';
exports.PLUGIN_ID = PLUGIN_ID;
const CONNECTOR_NATIVE_TYPE = 'native';
exports.CONNECTOR_NATIVE_TYPE = CONNECTOR_NATIVE_TYPE;
const CONNECTOR_CLIENTS_TYPE = 'connector_clients';
exports.CONNECTOR_CLIENTS_TYPE = CONNECTOR_CLIENTS_TYPE;