"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeRangeEmbeddableFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _time_range_embeddable = require("./time_range_embeddable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class TimeRangeEmbeddableFactory {
  constructor() {
    (0, _defineProperty2.default)(this, "type", _time_range_embeddable.TIME_RANGE_EMBEDDABLE);
  }
  async isEditable() {
    return true;
  }
  async create(initialInput, parent) {
    return new _time_range_embeddable.TimeRangeEmbeddable(initialInput, parent);
  }
  getDisplayName() {
    return 'time range';
  }
}
exports.TimeRangeEmbeddableFactory = TimeRangeEmbeddableFactory;