"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldFetch$ = shouldFetch$;
exports.shouldRefreshFilterCompareOptions = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _operators = require("rxjs/operators");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const shouldRefreshFilterCompareOptions = {
  ..._esQuery.COMPARE_ALL_OPTIONS,
  // do not compare $state to avoid refreshing when filter is pinned/unpinned (which does not impact results)
  state: false
};
exports.shouldRefreshFilterCompareOptions = shouldRefreshFilterCompareOptions;
function shouldFetch$(updated$, getInput) {
  return updated$.pipe((0, _operators.map)(() => getInput())).pipe(
  // wrapping distinctUntilChanged with startWith and skip to prime distinctUntilChanged with an initial input value.
  (0, _operators.startWith)(getInput()), (0, _operators.distinctUntilChanged)((previous, current) => {
    if (!(0, _fastDeepEqual.default)([previous.searchSessionId, previous.query, previous.timeRange, previous.timeslice], [current.searchSessionId, current.query, current.timeRange, current.timeslice])) {
      return false;
    }
    return (0, _esQuery.onlyDisabledFiltersChanged)(previous.filters, current.filters, shouldRefreshFilterCompareOptions);
  }), (0, _operators.skip)(1));
}