"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSelectFromEmbeddableOutput = exports.useSelectFromEmbeddableInput = void 0;
var _react = require("react");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useSelectFromEmbeddableInput = (key, embeddable) => {
  const [value, setValue] = (0, _react.useState)(embeddable === null || embeddable === void 0 ? void 0 : embeddable.getInput()[key]);
  (0, _react.useEffect)(() => {
    const subscription = embeddable === null || embeddable === void 0 ? void 0 : embeddable.getInput$().pipe((0, _rxjs.distinctUntilKeyChanged)(key)).subscribe(() => setValue(embeddable.getInput()[key]));
    return () => subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
  }, [embeddable, key]);
  return value;
};
exports.useSelectFromEmbeddableInput = useSelectFromEmbeddableInput;
const useSelectFromEmbeddableOutput = (key, embeddable) => {
  const [value, setValue] = (0, _react.useState)(embeddable.getOutput()[key]);
  (0, _react.useEffect)(() => {
    const subscription = embeddable.getOutput$().pipe((0, _rxjs.distinctUntilKeyChanged)(key)).subscribe(() => setValue(embeddable.getOutput()[key]));
    return () => subscription.unsubscribe();
  }, [embeddable, key]);
  return value;
};
exports.useSelectFromEmbeddableOutput = useSelectFromEmbeddableOutput;