"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddablePanelHeader = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lib = require("../../lib");
var _embeddable_panel_title = require("./embeddable_panel_title");
var _embeddable_panel_strings = require("../embeddable_panel_strings");
var _use_embeddable_panel_badges = require("./use_embeddable_panel_badges");
var _use_select_from_embeddable = require("../use_select_from_embeddable");
var _embeddable_panel_context_menu = require("./embeddable_panel_context_menu");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const EmbeddablePanelHeader = ({
  index,
  headerId,
  getActions,
  embeddable,
  actionPredicate,
  universalActions,
  showBadges = true,
  showNotifications = true
}) => {
  var _badgeComponents$leng, _notificationComponen;
  const selfStyledEmbeddableOptions = (0, _react.useMemo)(() => (0, _lib.isSelfStyledEmbeddable)(embeddable) ? embeddable.getSelfStyledOptions() : undefined, [embeddable]);
  const {
    notificationComponents,
    badgeComponents
  } = (0, _use_embeddable_panel_badges.useEmbeddablePanelBadges)(showNotifications, showBadges, embeddable, getActions);
  const title = embeddable.getTitle();
  const description = embeddable.getDescription();
  const viewMode = (0, _use_select_from_embeddable.useSelectFromEmbeddableInput)('viewMode', embeddable);
  const hidePanelTitle = (0, _use_select_from_embeddable.useSelectFromEmbeddableInput)('hidePanelTitles', embeddable);
  const parentHidePanelTitle = (0, _use_select_from_embeddable.useSelectFromEmbeddableInput)('hidePanelTitles', embeddable.parent);
  const hideTitle = Boolean(hidePanelTitle) || Boolean(parentHidePanelTitle) || Boolean(selfStyledEmbeddableOptions === null || selfStyledEmbeddableOptions === void 0 ? void 0 : selfStyledEmbeddableOptions.hideTitle) || viewMode === _lib.ViewMode.VIEW && !Boolean(title);
  const showPanelBar = !hideTitle || description || viewMode !== _lib.ViewMode.VIEW || ((_badgeComponents$leng = badgeComponents === null || badgeComponents === void 0 ? void 0 : badgeComponents.length) !== null && _badgeComponents$leng !== void 0 ? _badgeComponents$leng : 0) > 0 || ((_notificationComponen = notificationComponents === null || notificationComponents === void 0 ? void 0 : notificationComponents.length) !== null && _notificationComponen !== void 0 ? _notificationComponen : 0) > 0;
  const ariaLabel = (0, _embeddable_panel_strings.getAriaLabelForTitle)(showPanelBar ? title : undefined);
  const ariaLabelElement = /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", {
    id: headerId
  }, ariaLabel));
  const headerClasses = (0, _classnames.default)('embPanel__header', {
    'embPanel__header--floater': !showPanelBar
  });
  const titleClasses = (0, _classnames.default)('embPanel__title', {
    'embPanel--dragHandle': viewMode === _lib.ViewMode.EDIT
  });
  const embeddablePanelContextMenu = /*#__PURE__*/_react.default.createElement(_embeddable_panel_context_menu.EmbeddablePanelContextMenu, {
    index,
    embeddable,
    getActions,
    actionPredicate,
    universalActions
  });
  if (!showPanelBar) {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: headerClasses
    }, embeddablePanelContextMenu, ariaLabelElement);
  }
  return /*#__PURE__*/_react.default.createElement("figcaption", {
    className: headerClasses,
    "data-test-subj": `embeddablePanelHeading-${(title || '').replace(/\s/g, '')}`
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "dashboardPanelTitle",
    className: titleClasses
  }, ariaLabelElement, /*#__PURE__*/_react.default.createElement(_embeddable_panel_title.EmbeddablePanelTitle, {
    viewMode: viewMode,
    hideTitle: hideTitle,
    embeddable: embeddable,
    description: description,
    customizePanelAction: universalActions.customizePanel
  }), showBadges && badgeComponents), showNotifications && notificationComponents, embeddablePanelContextMenu);
};
exports.EmbeddablePanelHeader = EmbeddablePanelHeader;