"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FiltersDetails = FiltersDetails;
exports.filterDetailsActionStrings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/unified-search-plugin/public");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _filterable_embeddable = require("../../../lib/filterable_embeddable");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const filterDetailsActionStrings = {
  getQueryTitle: () => _i18n.i18n.translate('embeddableApi.panel.filters.queryTitle', {
    defaultMessage: 'Query'
  }),
  getFiltersTitle: () => _i18n.i18n.translate('embeddableApi.panel.filters.filtersTitle', {
    defaultMessage: 'Filters'
  })
};
exports.filterDetailsActionStrings = filterDetailsActionStrings;
function FiltersDetails({
  embeddable,
  editMode,
  onEdit
}) {
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [filters, setFilters] = (0, _react.useState)([]);
  const [queryString, setQueryString] = (0, _react.useState)('');
  const [queryLanguage, setQueryLanguage] = (0, _react.useState)();
  const [disableEditbutton, setDisableEditButton] = (0, _react.useState)(false);
  const dataViews = (0, _react.useMemo)(() => embeddable.getOutput().indexPatterns || [], [embeddable]);
  (0, _useMount.default)(() => {
    if (!(0, _filterable_embeddable.isFilterableEmbeddable)(embeddable)) {
      setIsLoading(false);
      return;
    }
    Promise.all([embeddable.getFilters(), embeddable.getQuery()]).then(([embeddableFilters, embeddableQuery]) => {
      setFilters(embeddableFilters);
      if (embeddableQuery) {
        if ((0, _esQuery.isOfQueryType)(embeddableQuery)) {
          if (typeof embeddableQuery.query === 'string') {
            setQueryString(embeddableQuery.query);
          } else {
            setQueryString(JSON.stringify(embeddableQuery.query, null, 2));
          }
        } else {
          const language = (0, _esQuery.getAggregateQueryMode)(embeddableQuery);
          setQueryLanguage(language);
          setQueryString(embeddableQuery[language]);
          setDisableEditButton(true);
        }
      }
      setIsLoading(false);
    });
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    isLoading: isLoading,
    lines: 3
  }, queryString !== '' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: filterDetailsActionStrings.getQueryTitle(),
    display: "rowCompressed",
    labelAppend: editMode && !disableEditbutton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      "data-test-subj": "customizePanelEditQueryButton",
      onClick: onEdit,
      "aria-label": _i18n.i18n.translate('embeddableApi.customizePanel.flyout.optionsMenuForm.editQueryButtonAriaLabel', {
        defaultMessage: 'Edit query'
      })
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "embeddableApi.customizePanel.flyout.optionsMenuForm.editQueryButtonLabel",
      defaultMessage: "Edit"
    })) : null
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: queryLanguage,
    paddingSize: "s",
    fontSize: "s",
    "aria-labelledby": `${filterDetailsActionStrings.getQueryTitle()}: ${queryString}`,
    tabIndex: 0 // focus so that keyboard controls will not skip over the code block
  }, queryString)), filters.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: filterDetailsActionStrings.getFiltersTitle(),
    labelAppend: editMode && !disableEditbutton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      "data-test-subj": "customizePanelEditFiltersButton",
      onClick: onEdit,
      "aria-label": _i18n.i18n.translate('embeddableApi.customizePanel.flyout.optionsMenuForm.editFiltersButtonAriaLabel', {
        defaultMessage: 'Edit filters'
      })
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "embeddableApi.customizePanel.flyout.optionsMenuForm.editFiltersButtonLabel",
      defaultMessage: "Edit"
    })) : null
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_public.FilterItems, {
    filters: filters,
    indexPatterns: dataViews,
    readOnly: true
  }))));
}