"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomizePanelAction = exports.ACTION_CUSTOMIZE_PANEL = void 0;
exports.hasTimeRange = hasTimeRange;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _kibana_services = require("../../../kibana_services");
var _types = require("../../../lib/types");
var _track_overlays = require("../track_overlays");
var _customize_panel_editor = require("./customize_panel_editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_CUSTOMIZE_PANEL = 'ACTION_CUSTOMIZE_PANEL';
exports.ACTION_CUSTOMIZE_PANEL = ACTION_CUSTOMIZE_PANEL;
const VISUALIZE_EMBEDDABLE_TYPE = 'visualization';
function isVisualizeEmbeddable(embeddable) {
  return embeddable.type === VISUALIZE_EMBEDDABLE_TYPE;
}
function hasTimeRange(embeddable) {
  return embeddable.getInput().timeRange !== undefined;
}
class CustomizePanelAction {
  constructor(overlays, theme, editPanel, commonlyUsedRanges, dateFormat) {
    (0, _defineProperty2.default)(this, "type", ACTION_CUSTOMIZE_PANEL);
    (0, _defineProperty2.default)(this, "id", ACTION_CUSTOMIZE_PANEL);
    (0, _defineProperty2.default)(this, "order", 40);
    this.overlays = overlays;
    this.theme = theme;
    this.editPanel = editPanel;
    this.commonlyUsedRanges = commonlyUsedRanges;
    this.dateFormat = dateFormat;
  }
  isTimeRangeCompatible({
    embeddable
  }) {
    const isInputControl = isVisualizeEmbeddable(embeddable) && embeddable.getOutput().visTypeName === 'input_control_vis';
    const isMarkdown = isVisualizeEmbeddable(embeddable) && embeddable.getOutput().visTypeName === 'markdown';
    const isImage = embeddable.type === 'image';
    const isNavigation = embeddable.type === 'navigation';
    return Boolean(embeddable && hasTimeRange(embeddable) && !isInputControl && !isMarkdown && !isImage && !isNavigation);
  }
  getDisplayName({
    embeddable
  }) {
    return _i18n.i18n.translate('embeddableApi.customizePanel.action.displayName', {
      defaultMessage: 'Panel settings'
    });
  }
  getIconType() {
    return 'gear';
  }
  async isCompatible({
    embeddable
  }) {
    // It should be possible to customize just the time range in View mode
    return embeddable.getInput().viewMode === _types.ViewMode.EDIT || this.isTimeRangeCompatible({
      embeddable
    });
  }
  async execute({
    embeddable
  }) {
    const isCompatible = await this.isCompatible({
      embeddable
    });
    if (!isCompatible) {
      throw new _public2.IncompatibleActionError();
    }

    // send the overlay ref to the root embeddable if it is capable of tracking overlays
    const rootEmbeddable = embeddable.getRoot();
    const overlayTracker = (0, _track_overlays.tracksOverlays)(rootEmbeddable) ? rootEmbeddable : undefined;
    const {
      Provider: KibanaReactContextProvider
    } = (0, _public.createKibanaReactContext)({
      uiSettings: _kibana_services.core.uiSettings
    });
    const onEdit = () => {
      this.editPanel.execute({
        embeddable
      });
    };
    const handle = this.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, null, /*#__PURE__*/_react.default.createElement(_customize_panel_editor.CustomizePanelEditor, {
      embeddable: embeddable,
      timeRangeCompatible: this.isTimeRangeCompatible({
        embeddable
      }),
      dateFormat: this.dateFormat,
      commonlyUsedRanges: this.commonlyUsedRanges,
      onClose: () => {
        if (overlayTracker) overlayTracker.clearOverlays();
        handle.close();
      },
      onEdit: onEdit
    })), {
      theme: this.theme,
      i18n: _kibana_services.core.i18n
    }), {
      size: 's',
      'data-test-subj': 'customizePanel',
      onClose: overlayRef => {
        if (overlayTracker) overlayTracker.clearOverlays();
        overlayRef.close();
      },
      maxWidth: true
    });
    overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.openOverlay(handle);
  }
}
exports.CustomizePanelAction = CustomizePanelAction;