"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PostActionsConnectorExecutePathParams = exports.PostActionsConnectorExecuteBody = void 0;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Validates the URL path of a POST request to the `/actions/connector/{connector_id}/_execute` endpoint */
const PostActionsConnectorExecutePathParams = t.type({
  connectorId: t.string
});

/** Validates the body of a POST request to the `/actions/connector/{connector_id}/_execute` endpoint */
exports.PostActionsConnectorExecutePathParams = PostActionsConnectorExecutePathParams;
const PostActionsConnectorExecuteBody = t.type({
  params: t.type({
    subActionParams: t.intersection([t.type({
      messages: t.array(t.type({
        // must match ConversationRole from '@kbn/elastic-assistant
        role: t.union([t.literal('system'), t.literal('user'), t.literal('assistant')]),
        content: t.string
      }))
    }), t.partial({
      model: t.string,
      n: t.number,
      stop: t.union([t.string, t.array(t.string), t.null]),
      temperature: t.number
    })]),
    subAction: t.string
  }),
  alertsIndexPattern: t.union([t.string, t.undefined]),
  allow: t.union([t.array(t.string), t.undefined]),
  allowReplacement: t.union([t.array(t.string), t.undefined]),
  assistantLangChain: t.boolean,
  replacements: t.union([t.record(t.string, t.string), t.undefined]),
  size: t.union([t.number, t.undefined])
});
exports.PostActionsConnectorExecuteBody = PostActionsConnectorExecuteBody;