"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticAssistantPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _routes = require("./routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ElasticAssistantPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "createRouteHandlerContext", (core, logger) => {
      return async function elasticAssistantRouteHandlerContext(context, request) {
        const [_, pluginsStart] = await core.getStartServices();
        return {
          actions: pluginsStart.actions,
          logger
        };
      };
    });
    this.logger = initializerContext.logger.get();
  }
  setup(core, plugins) {
    this.logger.debug('elasticAssistant: Setup');
    const router = core.http.createRouter();
    core.http.registerRouteHandlerContext('elasticAssistant', this.createRouteHandlerContext(core, this.logger));
    const getElserId = (0, _lodash.once)(async (request, savedObjectsClient) => {
      return (await plugins.ml.trainedModelsProvider(request, savedObjectsClient).getELSER()).model_id;
    });

    // Knowledge Base
    (0, _routes.deleteKnowledgeBaseRoute)(router);
    (0, _routes.getKnowledgeBaseStatusRoute)(router, getElserId);
    (0, _routes.postKnowledgeBaseRoute)(router, getElserId);
    // Actions Connector Execute (LLM Wrapper)
    (0, _routes.postActionsConnectorExecuteRoute)(router, getElserId);
    // Evaluate
    (0, _routes.postEvaluateRoute)(router, getElserId);
    return {
      actions: plugins.actions
    };
  }
  start(core, plugins) {
    this.logger.debug('elasticAssistant: Started');
    return {
      actions: plugins.actions
    };
  }
  stop() {}
}
exports.ElasticAssistantPlugin = ElasticAssistantPlugin;