"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApplicableTools = void 0;
var _get_alert_counts_tool = require("./alert_counts/get_alert_counts_tool");
var _get_esql_language_knowledge_base_tool = require("./esql_language_knowledge_base/get_esql_language_knowledge_base_tool");
var _get_open_and_acknowledged_alerts_tool = require("./open_and_acknowledged_alerts/get_open_and_acknowledged_alerts_tool");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getApplicableTools = ({
  alertsIndexPattern,
  allow,
  allowReplacement,
  assistantLangChain,
  chain,
  esClient,
  modelExists,
  onNewReplacements,
  replacements,
  request,
  size
}) => {
  var _getEsqlLanguageKnowl, _getAlertCountsTool, _getOpenAndAcknowledg;
  return [(_getEsqlLanguageKnowl = (0, _get_esql_language_knowledge_base_tool.getEsqlLanguageKnowledgeBaseTool)({
    assistantLangChain,
    chain,
    modelExists
  })) !== null && _getEsqlLanguageKnowl !== void 0 ? _getEsqlLanguageKnowl : [], (_getAlertCountsTool = (0, _get_alert_counts_tool.getAlertCountsTool)({
    alertsIndexPattern,
    esClient,
    replacements,
    request
  })) !== null && _getAlertCountsTool !== void 0 ? _getAlertCountsTool : [], (_getOpenAndAcknowledg = (0, _get_open_and_acknowledged_alerts_tool.getOpenAndAcknowledgedAlertsTool)({
    alertsIndexPattern,
    allow,
    allowReplacement,
    esClient,
    onNewReplacements,
    replacements,
    request,
    size
  })) !== null && _getOpenAndAcknowledg !== void 0 ? _getOpenAndAcknowledg : []].flat();
};
exports.getApplicableTools = getApplicableTools;