"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEsqlLanguageKnowledgeBaseTool = void 0;
var _tools = require("langchain/tools");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEsqlLanguageKnowledgeBaseTool = ({
  assistantLangChain,
  modelExists,
  chain
}) => assistantLangChain && modelExists ? new _tools.ChainTool({
  name: 'ESQLKnowledgeBaseTool',
  description: 'Call this for knowledge on how to build an ESQL query, or answer questions about the ES|QL query language.',
  chain,
  tags: ['esql', 'query-generation', 'knowledge-base']
}) : null;
exports.getEsqlLanguageKnowledgeBaseTool = getEsqlLanguageKnowledgeBaseTool;