"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isAWSLambdaAgentName = isAWSLambdaAgentName;
exports.isAndroidAgentName = isAndroidAgentName;
exports.isAzureFunctionsAgentName = isAzureFunctionsAgentName;
exports.isIosAgentName = isIosAgentName;
exports.isJRubyAgentName = isJRubyAgentName;
exports.isJavaAgentName = isJavaAgentName;
exports.isMobileAgentName = isMobileAgentName;
exports.isOpenTelemetryAgentName = isOpenTelemetryAgentName;
exports.isRumAgentName = isRumAgentName;
exports.isRumOrMobileAgentName = isRumOrMobileAgentName;
exports.isServerlessAgentName = isServerlessAgentName;
var _agent_names = require("./agent_names");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function isOpenTelemetryAgentName(agentName) {
  return _agent_names.OPEN_TELEMETRY_AGENT_NAMES.includes(agentName);
}
function isJavaAgentName(agentName) {
  return _agent_names.JAVA_AGENT_NAMES.includes(agentName);
}
function isRumAgentName(agentName) {
  return _agent_names.RUM_AGENT_NAMES.includes(agentName);
}
function isMobileAgentName(agentName) {
  return isIosAgentName(agentName) || isAndroidAgentName(agentName);
}
function isRumOrMobileAgentName(agentName) {
  return isRumAgentName(agentName) || isMobileAgentName(agentName);
}
function isIosAgentName(agentName) {
  return (agentName === null || agentName === void 0 ? void 0 : agentName.toLowerCase()) === 'ios/swift';
}
function isAndroidAgentName(agentName) {
  const lowercased = agentName && agentName.toLowerCase();
  return lowercased === 'android/java';
}
function isJRubyAgentName(agentName, runtimeName) {
  return agentName === 'ruby' && (runtimeName === null || runtimeName === void 0 ? void 0 : runtimeName.toLowerCase()) === 'jruby';
}
function isServerlessAgentName(serverlessType) {
  return isAWSLambdaAgentName(serverlessType) || isAzureFunctionsAgentName(serverlessType);
}
function isAWSLambdaAgentName(serverlessType) {
  return serverlessType === 'aws.lambda';
}
function isAzureFunctionsAgentName(serverlessType) {
  return serverlessType === 'azure.functions';
}