"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValidFilters = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getValidFilters = (dataView, filters) => {
  return filters.map(filter => {
    var _filter$query;
    const meta = {
      ...filter.meta
    };

    // We need to disable scripted filters that don't match this data view
    // since we can't guarantee they'll succeed for the current data view
    // and can lead to runtime errors
    if ((_filter$query = filter.query) !== null && _filter$query !== void 0 && _filter$query.script && meta.index !== dataView.id) {
      meta.disabled = true;
    }
    return {
      ...filter,
      meta
    };
  });
};
exports.getValidFilters = getValidFilters;