"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syncHistoryLocations = exports.setUrlTracker = exports.setUiActions = exports.setScopedHistory = exports.setHeaderActionMenuMounter = exports.getUrlTracker = exports.getUiActions = exports.getScopedHistory = exports.getHistory = exports.getHeaderActionMenuMounter = void 0;
var _lodash = require("lodash");
var _history = require("history");
var _public = require("@kbn/kibana-utils-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let uiActions;
const setUiActions = pluginUiActions => uiActions = pluginUiActions;
exports.setUiActions = setUiActions;
const getUiActions = () => uiActions;
exports.getUiActions = getUiActions;
const [getHeaderActionMenuMounter, setHeaderActionMenuMounter] = (0, _public.createGetterSetter)('headerActionMenuMounter');
exports.setHeaderActionMenuMounter = setHeaderActionMenuMounter;
exports.getHeaderActionMenuMounter = getHeaderActionMenuMounter;
const [getUrlTracker, setUrlTracker] = (0, _public.createGetterSetter)('urlTracker');

/**
 * Makes sure discover and context are using one instance of history.
 */
exports.setUrlTracker = setUrlTracker;
exports.getUrlTracker = getUrlTracker;
const getHistory = (0, _lodash.once)(() => {
  const history = (0, _history.createHashHistory)();
  history.listen(() => {
    // keep at least one listener so that `history.location` always in sync
  });
  return history;
});

/**
 * Discover currently uses two `history` instances: one from Kibana Platform and
 * another from `history` package. Below function is used every time Discover
 * app is loaded to synchronize both instances.
 *
 * This helper is temporary until https://github.com/elastic/kibana/issues/65161 is resolved.
 */
exports.getHistory = getHistory;
const syncHistoryLocations = () => {
  const h = getHistory();
  Object.assign(h.location, (0, _history.createHashHistory)().location);
  return h;
};
exports.syncHistoryLocations = syncHistoryLocations;
const [getScopedHistory, setScopedHistory] = (0, _public.createGetterSetter)('scopedHistory');
exports.setScopedHistory = setScopedHistory;
exports.getScopedHistory = getScopedHistory;