"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDiscoverLocatorParams = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getDiscoverLocatorParams = ({
  input,
  savedSearch
}) => {
  const dataView = savedSearch.searchSource.getField('index');
  const savedObjectId = input.savedObjectId;
  const locatorParams = savedObjectId ? {
    savedSearchId: savedObjectId
  } : {
    dataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id,
    dataViewSpec: dataView === null || dataView === void 0 ? void 0 : dataView.toMinimalSpec(),
    timeRange: savedSearch.timeRange,
    refreshInterval: savedSearch.refreshInterval,
    filters: savedSearch.searchSource.getField('filter'),
    query: savedSearch.searchSource.getField('query'),
    columns: savedSearch.columns,
    sort: savedSearch.sort,
    viewMode: savedSearch.viewMode,
    hideAggregatedPreview: savedSearch.hideAggregatedPreview,
    breakdownField: savedSearch.breakdownField
  };
  return locatorParams;
};
exports.getDiscoverLocatorParams = getDiscoverLocatorParams;