"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocTableWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _discoverUtils = require("@kbn/discover-utils");
var _table_header = require("./components/table_header/table_header");
var _table_row = require("./components/table_row");
var _use_discover_services = require("../../hooks/use_discover_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const wait = ms => new Promise(resolve => setTimeout(resolve, ms));
const DocTableWrapper = /*#__PURE__*/(0, _react.forwardRef)(({
  render,
  columns,
  filters,
  isPlainRecord,
  savedSearchId,
  rows,
  dataView,
  onSort,
  onAddColumn,
  onMoveColumn,
  onRemoveColumn,
  sort,
  onFilter,
  useNewFieldsApi,
  searchDescription,
  sharedItemTitle,
  dataTestSubj,
  isLoading
}, ref) => {
  const {
    uiSettings
  } = (0, _use_discover_services.useDiscoverServices)();
  const showMultiFields = (0, _react.useMemo)(() => uiSettings.get(_discoverUtils.SHOW_MULTIFIELDS, false), [uiSettings]);
  const onSkipBottomButtonClick = (0, _react.useCallback)(async () => {
    // delay scrolling to after the rows have been rendered
    const bottomMarker = document.getElementById('discoverBottomMarker');
    while (rows.length !== document.getElementsByClassName('kbnDocTable__row').length) {
      await wait(50);
    }
    bottomMarker.focus();
    await wait(50);
    bottomMarker.blur();
  }, [rows]);
  const shouldShowFieldHandler = (0, _react.useMemo)(() => (0, _discoverUtils.getShouldShowFieldHandler)(dataView.fields.map(field => field.name), dataView, showMultiFields), [dataView, showMultiFields]);
  const renderHeader = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.createElement(_table_header.TableHeader, {
    columns: columns,
    dataView: dataView,
    onChangeSortOrder: onSort,
    onMoveColumn: onMoveColumn,
    onRemoveColumn: onRemoveColumn,
    sortOrder: sort
  }), [columns, dataView, onMoveColumn, onRemoveColumn, onSort, sort]);
  const renderRows = (0, _react.useCallback)(rowsToRender => {
    return rowsToRender.map(current => /*#__PURE__*/_react.default.createElement(_table_row.TableRow, {
      key: `${current.id}${current.raw._score}${current.raw._version}`,
      columns: columns,
      filters: filters,
      savedSearchId: savedSearchId,
      filter: onFilter,
      dataView: dataView,
      row: current,
      useNewFieldsApi: useNewFieldsApi,
      shouldShowFieldHandler: shouldShowFieldHandler,
      onAddColumn: onAddColumn,
      onRemoveColumn: onRemoveColumn,
      isPlainRecord: isPlainRecord,
      rows: rows
    }));
  }, [columns, filters, savedSearchId, onFilter, dataView, useNewFieldsApi, shouldShowFieldHandler, onAddColumn, onRemoveColumn, isPlainRecord, rows]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "kbnDocTableWrapper eui-yScroll eui-xScroll",
    "data-shared-item": true,
    "data-title": sharedItemTitle,
    "data-description": searchDescription,
    "data-test-subj": dataTestSubj,
    "data-render-complete": !isLoading,
    ref: ref
  }, rows.length !== 0 && render({
    columnLength: columns.length,
    rows,
    onSkipBottomButtonClick,
    renderHeader,
    renderRows
  }), !rows.length && /*#__PURE__*/_react.default.createElement("div", {
    className: "kbnDocTable__error"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.loadingResults",
    defaultMessage: "Loading results"
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "discoverApp",
    size: "m",
    color: "subdued"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.docTable.noResultsTitle",
    defaultMessage: "No results found"
  })))));
});
exports.DocTableWrapper = DocTableWrapper;