"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DiscoverContainerInternal = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _main = require("../../application/main");
var _kibana_services = require("../../kibana_services");
var _loading_indicator = require("../common/loading_indicator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const discoverContainerWrapperCss = (0, _react2.css)`
  width: 100%;
  height: 100%;

  // override the embedded discover page height
  // to fit in the container
  .dscPage {
    height: 100%;
  }
`;
const DiscoverContainerInternal = ({
  overrideServices,
  scopedHistory,
  customizationCallbacks,
  isDev,
  getDiscoverServices,
  isLoading = false
}) => {
  const [discoverServices, setDiscoverServices] = (0, _react.useState)();
  const [initialized, setInitialized] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    getDiscoverServices().then(svcs => setDiscoverServices(svcs));
  }, [getDiscoverServices]);
  (0, _react.useEffect)(() => {
    (0, _kibana_services.setScopedHistory)(scopedHistory);
    (0, _kibana_services.setHeaderActionMenuMounter)(() => {});
    setInitialized(true);
  }, [scopedHistory]);
  const services = (0, _react.useMemo)(() => {
    if (!discoverServices) return;
    return {
      ...discoverServices,
      ...overrideServices
    };
  }, [discoverServices, overrideServices]);
  if (!initialized || !services || isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      css: discoverContainerWrapperCss
    }, /*#__PURE__*/_react.default.createElement(_loading_indicator.LoadingIndicator, {
      type: "spinner"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: discoverContainerWrapperCss,
    "data-test-subj": "discover-container-internal-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
          width: 100%;
        `
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_main.DiscoverMainRoute, {
    customizationCallbacks: customizationCallbacks,
    mode: "embedded",
    isDev: isDev
  }))));
};

// eslint-disable-next-line import/no-default-export
exports.DiscoverContainerInternal = DiscoverContainerInternal;
var _default = DiscoverContainerInternal;
exports.default = _default;