"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isTextBasedQuery = isTextBasedQuery;
var _discover_data_state_container = require("../services/discover_data_state_container");
var _get_raw_record_type = require("./get_raw_record_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Checks if the query is of AggregateQuery type
 * @param query
 */
function isTextBasedQuery(query) {
  return (0, _get_raw_record_type.getRawRecordType)(query) === _discover_data_state_container.RecordRawType.PLAIN;
}