"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRawRecordType = getRawRecordType;
var _esQuery = require("@kbn/es-query");
var _discover_data_state_container = require("../services/discover_data_state_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getRawRecordType(query) {
  if (query && (0, _esQuery.isOfAggregateQueryType)(query) && ((0, _esQuery.getAggregateQueryMode)(query) === 'sql' || (0, _esQuery.getAggregateQueryMode)(query) === 'esql')) {
    return _discover_data_state_container.RecordRawType.PLAIN;
  }
  return _discover_data_state_container.RecordRawType.DOCUMENT;
}