"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFetch$ = getFetch$;
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _types = require("../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * This function returns an observable that's used to trigger data fetching
 */
function getFetch$({
  setAutoRefreshDone,
  data,
  main$,
  refetch$,
  searchSessionManager
}) {
  const {
    timefilter
  } = data.query.timefilter;
  return (0, _rxjs.merge)(refetch$, timefilter.getFetch$(), timefilter.getAutoRefreshFetch$().pipe((0, _operators.tap)(done => {
    setAutoRefreshDone(done);
  }), (0, _operators.filter)(() => {
    const currentFetchStatus = main$.getValue().fetchStatus;
    return (
      /**
       * filter to prevent auto-refresh triggered fetch when
       * loading is still ongoing
       */
      currentFetchStatus !== _types.FetchStatus.LOADING && currentFetchStatus !== _types.FetchStatus.PARTIAL
    );
  })), searchSessionManager.newSearchSessionIdFromURL$.pipe((0, _operators.filter)(sessionId => !!sessionId))).pipe((0, _operators.debounceTime)(100));
}