"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataState = useDataState;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function useDataState(data$) {
  const [fetchState, setFetchState] = (0, _react.useState)(data$.getValue());
  (0, _react.useEffect)(() => {
    const subscription = data$.subscribe(next => {
      if (next.fetchStatus !== fetchState.fetchStatus) {
        setFetchState({
          ...fetchState,
          ...next,
          ...(next.error ? {} : {
            error: undefined
          })
        });
      }
    });
    return () => subscription.unsubscribe();
  }, [data$, fetchState, setFetchState]);
  return fetchState;
}