"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBehaviorSubject = useBehaviorSubject;
var _react = require("react");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function useBehaviorSubject(props) {
  const ref = (0, _react.useRef)(null);
  if (ref.current === null) {
    ref.current = new _rxjs.BehaviorSubject(props);
  }
  return ref.current;
}