"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TotalDocuments = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TotalDocuments = ({
  totalHitCount
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    size: "s",
    style: {
      paddingRight: 2
    },
    "data-test-subj": "savedSearchTotalDocuments"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.docTable.totalDocuments",
    defaultMessage: "{totalDocuments} documents",
    values: {
      totalDocuments: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: totalHitCount
      }))
    }
  }));
};
exports.TotalDocuments = TotalDocuments;