"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTopNavBadges = void 0;
var _unsavedChangesBadge = require("@kbn/unsaved-changes-badge");
var _on_save_search = require("./on_save_search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Helper function to build the top nav badges
 */
const getTopNavBadges = ({
  hasUnsavedChanges,
  stateContainer,
  services,
  topNavCustomization
}) => {
  var _topNavCustomization$, _topNavCustomization$2, _defaultBadges$unsave;
  const saveSearch = initialCopyOnSave => (0, _on_save_search.onSaveSearch)({
    initialCopyOnSave,
    savedSearch: stateContainer.savedSearchState.getState(),
    services,
    state: stateContainer
  });
  const defaultBadges = topNavCustomization === null || topNavCustomization === void 0 ? void 0 : topNavCustomization.defaultBadges;
  const entries = [...((_topNavCustomization$ = topNavCustomization === null || topNavCustomization === void 0 ? void 0 : (_topNavCustomization$2 = topNavCustomization.getBadges) === null || _topNavCustomization$2 === void 0 ? void 0 : _topNavCustomization$2.call(topNavCustomization)) !== null && _topNavCustomization$ !== void 0 ? _topNavCustomization$ : [])];
  if (hasUnsavedChanges && !(defaultBadges !== null && defaultBadges !== void 0 && (_defaultBadges$unsave = defaultBadges.unsavedChangesBadge) !== null && _defaultBadges$unsave !== void 0 && _defaultBadges$unsave.disabled)) {
    var _defaultBadges$unsave2, _defaultBadges$unsave3;
    entries.push({
      data: (0, _unsavedChangesBadge.getTopNavUnsavedChangesBadge)({
        onRevert: stateContainer.actions.undoSavedSearchChanges,
        onSave: async () => {
          await saveSearch();
        },
        onSaveAs: async () => {
          await saveSearch(true);
        }
      }),
      order: (_defaultBadges$unsave2 = defaultBadges === null || defaultBadges === void 0 ? void 0 : (_defaultBadges$unsave3 = defaultBadges.unsavedChangesBadge) === null || _defaultBadges$unsave3 === void 0 ? void 0 : _defaultBadges$unsave3.order) !== null && _defaultBadges$unsave2 !== void 0 ? _defaultBadges$unsave2 : 100
    });
  }
  return entries.sort((a, b) => a.order - b.order).map(entry => entry.data);
};
exports.getTopNavBadges = getTopNavBadges;