"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataViewFieldList = getDataViewFieldList;
exports.getTextBasedQueryFieldList = getTextBasedQueryFieldList;
var _lodash = require("lodash");
var _public = require("@kbn/data-views-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _discoverUtils = require("@kbn/discover-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getDataViewFieldList(dataView, fieldCounts) {
  var _dataView$getSourceFi, _dataView$getSourceFi2;
  if (!fieldCounts) {
    // still loading data
    return null;
  }
  const currentFieldCounts = fieldCounts || {};
  const sourceFiltersValues = dataView === null || dataView === void 0 ? void 0 : (_dataView$getSourceFi = dataView.getSourceFiltering) === null || _dataView$getSourceFi === void 0 ? void 0 : (_dataView$getSourceFi2 = _dataView$getSourceFi.call(dataView)) === null || _dataView$getSourceFi2 === void 0 ? void 0 : _dataView$getSourceFi2.excludes;
  let dataViewFields = (dataView === null || dataView === void 0 ? void 0 : dataView.fields.getAll()) || [];
  if (sourceFiltersValues) {
    const filter = (0, _public2.fieldWildcardFilter)(sourceFiltersValues, dataView.metaFields);
    dataViewFields = dataViewFields.filter(field => {
      return filter(field.name) || currentFieldCounts[field.name]; // don't filter out a field which was present in hits (ex. for selected fields)
    });
  }

  const fieldNamesInDocs = Object.keys(currentFieldCounts);
  const fieldNamesInDataView = dataViewFields.map(fld => fld.name);
  const unknownFields = [];
  (0, _lodash.difference)(fieldNamesInDocs, fieldNamesInDataView).forEach(unknownFieldName => {
    if (dataView && (0, _discoverUtils.isNestedFieldParent)(unknownFieldName, dataView)) {
      unknownFields.push(new _public.DataViewField({
        name: String(unknownFieldName),
        type: 'nested',
        searchable: false,
        aggregatable: false
      }));
    } else {
      unknownFields.push(new _public.DataViewField({
        name: String(unknownFieldName),
        type: 'unknown',
        searchable: false,
        aggregatable: false
      }));
    }
  });
  return [...dataViewFields, ...unknownFields];
}
function getTextBasedQueryFieldList(textBasedQueryColumns) {
  if (!textBasedQueryColumns) {
    return [];
  }
  return textBasedQueryColumns.map(column => {
    var _column$meta$type, _column$meta;
    return new _public.DataViewField({
      name: column.name,
      type: (_column$meta$type = (_column$meta = column.meta) === null || _column$meta === void 0 ? void 0 : _column$meta.type) !== null && _column$meta$type !== void 0 ? _column$meta$type : 'unknown',
      searchable: false,
      aggregatable: false
    });
  });
}