"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoResultsSuggestionWhenQuery = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _syntax_suggestions_popover = require("./syntax_suggestions_popover");
var _use_discover_services = require("../../../../../hooks/use_discover_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getExamples = (querySyntax, docLinks) => {
  if (!querySyntax) {
    return null;
  }
  if (querySyntax === 'lucene') {
    return {
      title: _i18n.i18n.translate('discover.noResults.luceneExamples.title', {
        defaultMessage: 'Lucene examples'
      }),
      items: [{
        label: _i18n.i18n.translate('discover.noResults.luceneExamples.findRequestsThatContain200Text', {
          defaultMessage: 'Find requests that contain the number 200, in any field'
        }),
        example: '200'
      }, {
        label: _i18n.i18n.translate('discover.noResults.luceneExamples.find200InStatusFieldText', {
          defaultMessage: 'Find 200 in the status field'
        }),
        example: 'status:200'
      }, {
        label: _i18n.i18n.translate('discover.noResults.luceneExamples.findAllStatusCodesText', {
          defaultMessage: 'Find all status codes between 400-499'
        }),
        example: 'status:[400 TO 499]'
      }, {
        label: _i18n.i18n.translate('discover.noResults.luceneExamples.findStatusCodesWithPHPText', {
          defaultMessage: 'Find status codes 400-499 with the extension php'
        }),
        example: 'status:[400 TO 499] AND extension:PHP'
      }, {
        label: _i18n.i18n.translate('discover.noResults.luceneExamples.findStatusCodesWithPhpOrHtmlText', {
          defaultMessage: 'Find status codes 400-499 with the extension php or html'
        }),
        example: 'status:[400 TO 499] AND (extension:php OR extension:html)'
      }],
      footer: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "discover.noResults.luceneExamples.footerDescription",
        defaultMessage: "Learn more about {luceneLink}",
        values: {
          luceneLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: docLinks.links.query.luceneQuerySyntax,
            target: "_blank"
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "discover.noResults.luceneExamples.footerLuceneLink",
            defaultMessage: "query string syntax"
          }))
        }
      })
    };
  }
  if (querySyntax === 'kuery') {
    return {
      title: _i18n.i18n.translate('discover.noResults.kqlExamples.title', {
        defaultMessage: 'KQL examples'
      }),
      items: [{
        label: _i18n.i18n.translate('discover.noResults.kqlExamples.filterForExistingFieldsText', {
          defaultMessage: 'Filter for documents where a field exists'
        }),
        example: 'http.request.method: *'
      }, {
        label: _i18n.i18n.translate('discover.noResults.kqlExamples.filterForDocsThatMatchValueText', {
          defaultMessage: 'Filter for documents that match a value'
        }),
        example: 'http.request.method: GET'
      }, {
        label: _i18n.i18n.translate('discover.noResults.kqlExamples.filterForDocsWithinRangeText', {
          defaultMessage: 'Filter for documents within a range'
        }),
        example: 'http.response.bytes > 10000 and http.response.bytes <= 20000'
      }, {
        label: _i18n.i18n.translate('discover.noResults.kqlExamples.filterForDocsWithWildcardsText', {
          defaultMessage: 'Filter for documents using wildcards'
        }),
        example: 'http.response.status_code: 4*'
      }, {
        label: _i18n.i18n.translate('discover.noResults.kqlExamples.negatingQueryText', {
          defaultMessage: 'Negating a query'
        }),
        example: 'NOT http.request.method: GET'
      }, {
        label: _i18n.i18n.translate('discover.noResults.kqlExamples.combineMultipleText', {
          defaultMessage: 'Combining multiple queries with AND/OR'
        }),
        example: 'http.request.method: GET AND http.response.status_code: 400'
      }, {
        label: _i18n.i18n.translate('discover.noResults.kqlExamples.queryMultipleText', {
          defaultMessage: 'Querying multiple values for the same field'
        }),
        example: 'http.request.method: (GET OR POST OR DELETE)'
      }],
      footer: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "discover.noResults.kqlExamples.kqlDescription",
        defaultMessage: "Learn more about {kqlLink}",
        values: {
          kqlLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: docLinks.links.query.kueryQuerySyntax,
            target: "_blank"
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "discover.noResults.kqlExamples.footerKQLLink",
            defaultMessage: "KQL"
          }))
        }
      })
    };
  }
  return null;
};
const NoResultsSuggestionWhenQuery = ({
  querySyntax
}) => {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    docLinks
  } = services;
  const examplesMeta = getExamples(querySyntax, docLinks);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "xs",
    responsive: false,
    wrap: false,
    css: (0, _react2.css)`
          display: inline-flex;
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "discoverNoResultsAdjustSearch"
  }, examplesMeta ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.noResults.suggestion.adjustYourQueryWithExamplesText",
    defaultMessage: "Try a different query"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.noResults.suggestion.adjustYourQueryText",
    defaultMessage: "Adjust your query"
  }))), !!examplesMeta && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_syntax_suggestions_popover.SyntaxSuggestionsPopover, {
    meta: examplesMeta
  }))));
};
exports.NoResultsSuggestionWhenQuery = NoResultsSuggestionWhenQuery;