"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIDEBAR_WIDTH_KEY = exports.DiscoverResizableLayout = void 0;
var _eui = require("@elastic/eui");
var _resizableLayout = require("@kbn/resizable-layout");
var _react = _interopRequireWildcard(require("react"));
var _reactReversePortal = require("react-reverse-portal");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const SIDEBAR_WIDTH_KEY = 'discover:sidebarWidth';
exports.SIDEBAR_WIDTH_KEY = SIDEBAR_WIDTH_KEY;
const DiscoverResizableLayout = ({
  container,
  unifiedFieldListSidebarContainerApi,
  sidebarPanel,
  mainPanel
}) => {
  var _unifiedFieldListSide;
  const [sidebarPanelNode] = (0, _react.useState)(() => (0, _reactReversePortal.createHtmlPortalNode)({
    attributes: {
      class: 'eui-fullHeight'
    }
  }));
  const [mainPanelNode] = (0, _react.useState)(() => (0, _reactReversePortal.createHtmlPortalNode)({
    attributes: {
      class: 'eui-fullHeight'
    }
  }));
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const minSidebarWidth = euiTheme.base * 13;
  const defaultSidebarWidth = euiTheme.base * 19;
  const minMainPanelWidth = euiTheme.base * 30;
  const [sidebarWidth, setSidebarWidth] = (0, _useLocalStorage.default)(SIDEBAR_WIDTH_KEY, defaultSidebarWidth);
  const isSidebarCollapsed = (0, _useObservable.default)((_unifiedFieldListSide = unifiedFieldListSidebarContainerApi === null || unifiedFieldListSidebarContainerApi === void 0 ? void 0 : unifiedFieldListSidebarContainerApi.isSidebarCollapsed$) !== null && _unifiedFieldListSide !== void 0 ? _unifiedFieldListSide : (0, _rxjs.of)(true), true);
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const layoutMode = isMobile || isSidebarCollapsed ? _resizableLayout.ResizableLayoutMode.Static : _resizableLayout.ResizableLayoutMode.Resizable;
  const layoutDirection = isMobile ? _resizableLayout.ResizableLayoutDirection.Vertical : _resizableLayout.ResizableLayoutDirection.Horizontal;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: sidebarPanelNode
  }, sidebarPanel), /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: mainPanelNode
  }, mainPanel), /*#__PURE__*/_react.default.createElement(_resizableLayout.ResizableLayout, {
    className: "dscPageBody__contents",
    mode: layoutMode,
    direction: layoutDirection,
    container: container,
    fixedPanelSize: sidebarWidth !== null && sidebarWidth !== void 0 ? sidebarWidth : defaultSidebarWidth,
    minFixedPanelSize: minSidebarWidth,
    minFlexPanelSize: minMainPanelWidth,
    fixedPanel: /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
      node: sidebarPanelNode
    }),
    flexPanel: /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
      node: mainPanelNode
    }),
    "data-test-subj": "discoverLayout",
    onFixedPanelSizeChange: setSidebarWidth
  }));
};
exports.DiscoverResizableLayout = DiscoverResizableLayout;