"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverLayout = DiscoverLayout;
require("./discover_layout.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _classnames = _interopRequireDefault(require("classnames"));
var _public = require("@kbn/data-plugin/public");
var _domDragDrop = require("@kbn/dom-drag-drop");
var _public2 = require("@kbn/data-views-plugin/public");
var _discoverUtils = require("@kbn/discover-utils");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _discover_state_provider = require("../../services/discover_state_provider");
var _constants = require("../../../../../common/constants");
var _discover_internal_state_container = require("../../services/discover_internal_state_container");
var _discover_app_state_container = require("../../services/discover_app_state_container");
var _use_inspector = require("../../hooks/use_inspector");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _no_results = require("../no_results");
var _loading_spinner = require("../loading_spinner/loading_spinner");
var _sidebar = require("../sidebar");
var _discover_topnav = require("../top_nav/discover_topnav");
var _get_result_state = require("../../utils/get_result_state");
var _uninitialized = require("../uninitialized/uninitialized");
var _discover_data_state_container = require("../../services/discover_data_state_container");
var _types = require("../../../types");
var _use_data_state = require("../../hooks/use_data_state");
var _get_raw_record_type = require("../../utils/get_raw_record_type");
var _saved_search_url_conflict_callout = require("../../../../components/saved_search_url_conflict_callout/saved_search_url_conflict_callout");
var _discover_histogram_layout = require("./discover_histogram_layout");
var _error_callout = require("../../../../components/common/error_callout");
var _add_log = require("../../../../utils/add_log");
var _discover_resizable_layout = require("./discover_resizable_layout");
var _esql_tech_preview_callout = require("./esql_tech_preview_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const SidebarMemoized = /*#__PURE__*/_react.default.memo(_sidebar.DiscoverSidebarResponsive);
const TopNavMemoized = /*#__PURE__*/_react.default.memo(_discover_topnav.DiscoverTopNav);
function DiscoverLayout({
  stateContainer
}) {
  const {
    trackUiMetric,
    capabilities,
    dataViews,
    data,
    uiSettings,
    filterManager,
    history,
    spaces,
    inspector,
    docLinks
  } = (0, _use_discover_services.useDiscoverServices)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const pageBackgroundColor = (0, _eui.useEuiBackgroundColor)('plain');
  const globalQueryState = data.query.getState();
  const {
    main$
  } = stateContainer.dataState.data$;
  const [query, savedQuery, columns, sort] = (0, _discover_app_state_container.useAppStateSelector)(state => [state.query, state.savedQuery, state.columns, state.sort]);
  const viewMode = (0, _discover_app_state_container.useAppStateSelector)(state => {
    var _state$viewMode;
    if (uiSettings.get(_discoverUtils.SHOW_FIELD_STATISTICS) !== true) return _constants.VIEW_MODE.DOCUMENT_LEVEL;
    return (_state$viewMode = state.viewMode) !== null && _state$viewMode !== void 0 ? _state$viewMode : _constants.VIEW_MODE.DOCUMENT_LEVEL;
  });
  const dataView = (0, _discover_internal_state_container.useInternalStateSelector)(state => state.dataView);
  const dataState = (0, _use_data_state.useDataState)(main$);
  const savedSearch = (0, _discover_state_provider.useSavedSearchInitial)();
  const fetchCounter = (0, _react.useRef)(0);
  (0, _react.useEffect)(() => {
    if (dataState.fetchStatus === _types.FetchStatus.LOADING) {
      fetchCounter.current++;
    }
  }, [dataState.fetchStatus]);

  // We treat rollup v1 data views as non time based in Discover, since we query them
  // in a non time based way using the regular _search API, since the internal
  // representation of those documents does not have the time field that _field_caps
  // reports us.
  const isTimeBased = (0, _react.useMemo)(() => {
    return dataView.type !== _public2.DataViewType.ROLLUP && dataView.isTimeBased();
  }, [dataView]);
  const useNewFieldsApi = (0, _react.useMemo)(() => !uiSettings.get(_discoverUtils.SEARCH_FIELDS_FROM_SOURCE), [uiSettings]);
  const isPlainRecord = (0, _react.useMemo)(() => (0, _get_raw_record_type.getRawRecordType)(query) === _discover_data_state_container.RecordRawType.PLAIN, [query]);
  const resultState = (0, _react.useMemo)(() => {
    var _dataState$foundDocum;
    return (0, _get_result_state.getResultState)(dataState.fetchStatus, (_dataState$foundDocum = dataState.foundDocuments) !== null && _dataState$foundDocum !== void 0 ? _dataState$foundDocum : false);
  }, [dataState.fetchStatus, dataState.foundDocuments]);
  const onOpenInspector = (0, _use_inspector.useInspector)({
    inspector,
    stateContainer
  });
  const {
    columns: currentColumns,
    onAddColumn,
    onRemoveColumn
  } = (0, _unifiedDataTable.useColumns)({
    capabilities,
    defaultOrder: uiSettings.get(_discoverUtils.SORT_DEFAULT_ORDER_SETTING),
    dataView,
    dataViews,
    setAppState: stateContainer.appState.update,
    useNewFieldsApi,
    columns,
    sort
  });
  const onAddFilter = (0, _react.useCallback)((field, values, operation) => {
    const fieldName = typeof field === 'string' ? field : field.name;
    (0, _unifiedDataTable.popularizeField)(dataView, fieldName, dataViews, capabilities);
    const newFilters = (0, _public.generateFilters)(filterManager, field, values, operation, dataView);
    if (trackUiMetric) {
      trackUiMetric(_analytics.METRIC_TYPE.CLICK, 'filter_added');
    }
    return filterManager.addFilters(newFilters);
  }, [filterManager, dataView, dataViews, trackUiMetric, capabilities]);
  const onFieldEdited = (0, _react.useCallback)(async ({
    removedFieldName
  } = {}) => {
    if (removedFieldName && currentColumns.includes(removedFieldName)) {
      onRemoveColumn(removedFieldName);
    }
    if (!dataView.isPersisted()) {
      await stateContainer.actions.updateAdHocDataViewId();
    }
    stateContainer.dataState.refetch$.next('reset');
  }, [dataView, stateContainer, currentColumns, onRemoveColumn]);
  const onDisableFilters = (0, _react.useCallback)(() => {
    const disabledFilters = filterManager.getFilters().map(filter => ({
      ...filter,
      meta: {
        ...filter.meta,
        disabled: true
      }
    }));
    filterManager.setFilters(disabledFilters);
  }, [filterManager]);
  const contentCentered = resultState === 'uninitialized' || resultState === 'none';
  const documentState = (0, _use_data_state.useDataState)(stateContainer.dataState.data$.documents$);
  const textBasedLanguageModeWarning = (0, _react.useMemo)(() => {
    if (isPlainRecord) {
      return documentState.textBasedHeaderWarning;
    }
  }, [documentState.textBasedHeaderWarning, isPlainRecord]);
  const textBasedLanguageModeErrors = (0, _react.useMemo)(() => {
    if (isPlainRecord) {
      return dataState.error;
    }
  }, [dataState.error, isPlainRecord]);
  const [sidebarContainer, setSidebarContainer] = (0, _react.useState)(null);
  const [mainContainer, setMainContainer] = (0, _react.useState)(null);
  const [{
    dragging
  }] = (0, _domDragDrop.useDragDropContext)();
  const draggingFieldName = dragging === null || dragging === void 0 ? void 0 : dragging.id;
  const onDropFieldToTable = (0, _react.useMemo)(() => {
    if (!draggingFieldName || currentColumns.includes(draggingFieldName)) {
      return undefined;
    }
    return () => onAddColumn(draggingFieldName);
  }, [onAddColumn, draggingFieldName, currentColumns]);
  const mainDisplay = (0, _react.useMemo)(() => {
    if (resultState === 'uninitialized') {
      (0, _add_log.addLog)('[DiscoverLayout] uninitialized triggers data fetching');
      return /*#__PURE__*/_react.default.createElement(_uninitialized.DiscoverUninitialized, {
        onRefresh: () => stateContainer.dataState.fetch()
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isPlainRecord && /*#__PURE__*/_react.default.createElement(_esql_tech_preview_callout.ESQLTechPreviewCallout, {
      docLinks: docLinks
    }), /*#__PURE__*/_react.default.createElement(_discover_histogram_layout.DiscoverHistogramLayout, {
      isPlainRecord: isPlainRecord,
      dataView: dataView,
      stateContainer: stateContainer,
      columns: currentColumns,
      viewMode: viewMode,
      onAddFilter: onAddFilter,
      onFieldEdited: onFieldEdited,
      container: mainContainer,
      onDropFieldToTable: onDropFieldToTable
    }), resultState === 'loading' && /*#__PURE__*/_react.default.createElement(_loading_spinner.LoadingSpinner, null));
  }, [currentColumns, dataView, docLinks, isPlainRecord, mainContainer, onAddFilter, onDropFieldToTable, onFieldEdited, resultState, stateContainer, viewMode]);
  const [unifiedFieldListSidebarContainerApi, setUnifiedFieldListSidebarContainerApi] = (0, _react.useState)(null);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    className: "dscPage",
    "data-fetch-counter": fetchCounter.current,
    css: (0, _react2.css)`
        background-color: ${pageBackgroundColor};
      `
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: "savedSearchTitle",
    className: "euiScreenReaderOnly",
    "data-test-subj": "discoverSavedSearchTitle"
  }, savedSearch.title ? _i18n.i18n.translate('discover.pageTitleWithSavedSearch', {
    defaultMessage: 'Discover - {savedSearchTitle}',
    values: {
      savedSearchTitle: savedSearch.title
    }
  }) : _i18n.i18n.translate('discover.pageTitleWithoutSavedSearch', {
    defaultMessage: 'Discover - Search not yet saved'
  })), /*#__PURE__*/_react.default.createElement(TopNavMemoized, {
    onOpenInspector: onOpenInspector,
    query: query,
    savedQuery: savedQuery,
    stateContainer: stateContainer,
    updateQuery: stateContainer.actions.onUpdateQuery,
    isPlainRecord: isPlainRecord,
    textBasedLanguageModeErrors: textBasedLanguageModeErrors,
    textBasedLanguageModeWarning: textBasedLanguageModeWarning,
    onFieldEdited: onFieldEdited
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    className: "dscPageBody",
    "aria-describedby": "savedSearchTitle"
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: setSidebarContainer,
    css: (0, _react2.css)`
            width: 100%;
            height: 100%;
          `
  }, /*#__PURE__*/_react.default.createElement(_saved_search_url_conflict_callout.SavedSearchURLConflictCallout, {
    savedSearch: savedSearch,
    spaces: spaces,
    history: history
  }), /*#__PURE__*/_react.default.createElement(_discover_resizable_layout.DiscoverResizableLayout, {
    container: sidebarContainer,
    unifiedFieldListSidebarContainerApi: unifiedFieldListSidebarContainerApi,
    sidebarPanel: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      css: (0, _react2.css)`
                  height: 100%;
                `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(SidebarMemoized, {
      documents$: stateContainer.dataState.data$.documents$,
      onAddField: onAddColumn,
      columns: currentColumns,
      onAddFilter: !isPlainRecord ? onAddFilter : undefined,
      onRemoveField: onRemoveColumn,
      onChangeDataView: stateContainer.actions.onChangeDataView,
      selectedDataView: dataView,
      trackUiMetric: trackUiMetric,
      onFieldEdited: onFieldEdited,
      onDataViewCreated: stateContainer.actions.onDataViewCreated,
      availableFields$: stateContainer.dataState.data$.availableFields$,
      unifiedFieldListSidebarContainerApi: unifiedFieldListSidebarContainerApi,
      setUnifiedFieldListSidebarContainerApi: setUnifiedFieldListSidebarContainerApi
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
      sizes: ['xs', 's']
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: (0, _react2.css)`
                      border-right: ${euiTheme.border.thin};
                    `
    }))),
    mainPanel: /*#__PURE__*/_react.default.createElement("div", {
      className: "dscPageContent__wrapper"
    }, resultState === 'none' ? dataState.error ? /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, {
      title: _i18n.i18n.translate('discover.noResults.searchExamples.noResultsErrorTitle', {
        defaultMessage: 'Unable to retrieve search results'
      }),
      error: dataState.error
    }) : /*#__PURE__*/_react.default.createElement(_no_results.DiscoverNoResults, {
      stateContainer: stateContainer,
      isTimeBased: isTimeBased,
      query: globalQueryState.query,
      filters: globalQueryState.filters,
      dataView: dataView,
      onDisableFilters: onDisableFilters
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      role: "main",
      panelRef: setMainContainer,
      paddingSize: "none",
      borderRadius: "none",
      hasShadow: false,
      hasBorder: false,
      color: "transparent",
      className: (0, _classnames.default)('dscPageContent', {
        'dscPageContent--centered': contentCentered
      })
    }, mainDisplay))
  }))));
}