"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasExactlyOneIndexPattern = exports.getIndexPatterns = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isOutputWithIndexPatterns = output => {
  if (!output || typeof output !== 'object') return false;
  return Array.isArray(output.indexPatterns);
};
const getIndexPatterns = embeddable => {
  if (!embeddable) return [];
  const output = embeddable.getOutput();
  return isOutputWithIndexPatterns(output) ? output.indexPatterns.map(({
    id
  }) => id) : [];
};
exports.getIndexPatterns = getIndexPatterns;
const hasExactlyOneIndexPattern = embeddable => getIndexPatterns(embeddable).length === 1;
exports.hasExactlyOneIndexPattern = hasExactlyOneIndexPattern;