"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataStreamsRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _default_api_types = require("../../types/default_api_types");
var _create_datasets_quality_server_route = require("../create_datasets_quality_server_route");
var _get_data_streams = require("./get_data_streams");
var _get_data_streams_stats = require("./get_data_streams_stats");
var _get_malformed_docs = require("./get_malformed_docs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/stats',
  params: t.type({
    query: t.intersection([_default_api_types.dataStreamTypesRt, t.partial({
      datasetQuery: t.string
    })])
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      context,
      params,
      plugins
    } = resources;
    const coreContext = await context.core;

    // Query datastreams as the current user as the Kibana internal user may not have all the required permissions
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    const fleetPluginStart = await plugins.fleet.start();
    const packageClient = fleetPluginStart.packageService.asInternalUser;
    const packages = await packageClient.getPackages();
    const [dataStreams, dataStreamsStats] = await Promise.all([(0, _get_data_streams.getDataStreams)({
      esClient,
      ...params.query,
      uncategorisedOnly: false
    }), (0, _get_data_streams_stats.getDataStreamsStats)({
      esClient,
      ...params.query
    })]);
    const installedPackages = dataStreams.items.map(item => item.integration);
    const integrations = packages.filter(pkg => installedPackages.includes(pkg.name)).map(p => ({
      name: p.name,
      title: p.title,
      version: p.version,
      icons: p.icons
    }));
    return {
      dataStreamsStats: (0, _lodash.values)((0, _lodash.merge)((0, _lodash.keyBy)(dataStreams.items, 'name'), (0, _lodash.keyBy)(dataStreamsStats.items, 'name'))),
      integrations
    };
  }
});
const malformedDocsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/malformed_docs',
  params: t.type({
    query: t.intersection([_default_api_types.rangeRt, _default_api_types.dataStreamTypesRt, t.partial({
      datasetQuery: t.string
    })])
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      context,
      params
    } = resources;
    const coreContext = await context.core;
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    const malformedDocs = await (0, _get_malformed_docs.getMalformedDocsPaginated)({
      esClient,
      ...params.query
    });
    return {
      malformedDocs
    };
  }
});
const dataStreamsRouteRepository = {
  ...statsRoute,
  ...malformedDocsRoute
};
exports.dataStreamsRouteRepository = dataStreamsRouteRepository;