"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMalformedDocsPaginated = getMalformedDocsPaginated;
var _server = require("@kbn/observability-plugin/server");
var _es_fields = require("../../../common/es_fields");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getMalformedDocsPaginated(options) {
  var _response$aggregation, _response$aggregation2, _response$aggregation3;
  const {
    esClient,
    type = 'logs',
    datasetQuery,
    start,
    end,
    after,
    prevResults = []
  } = options;
  const datasetQualityESClient = (0, _utils.createDatasetQualityESClient)(esClient);
  const response = await datasetQualityESClient.search({
    index: '*',
    size: 0,
    query: {
      bool: {
        ...(datasetQuery ? {
          should: [...(0, _utils.wildcardQuery)(_es_fields.DATA_STREAM_DATASET, datasetQuery), ...(0, _utils.wildcardQuery)(_es_fields.DATA_STREAM_NAMESPACE, datasetQuery)],
          minimum_should_match: 1
        } : {}),
        filter: [...(0, _server.rangeQuery)(start, end), ...(0, _server.termQuery)(_es_fields.DATA_STREAM_TYPE, type)]
      }
    },
    aggs: {
      datasets: {
        composite: {
          ...(after ? {
            after
          } : {}),
          size: 10000,
          sources: [{
            dataset: {
              terms: {
                field: _es_fields.DATA_STREAM_DATASET
              }
            }
          }, {
            namespace: {
              terms: {
                field: _es_fields.DATA_STREAM_NAMESPACE
              }
            }
          }]
        },
        aggs: {
          malformed: {
            filter: {
              exists: {
                field: _es_fields._IGNORED
              }
            }
          }
        }
      }
    }
  });
  const currMalformedDocs = (_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.datasets.buckets.map(bucket => ({
    dataset: `${type}-${bucket.key.dataset}-${bucket.key.namespace}`,
    percentage: bucket.malformed.doc_count * 100 / bucket.doc_count
  }))) !== null && _response$aggregation !== void 0 ? _response$aggregation : [];
  const malformedDocs = [...prevResults, ...currMalformedDocs];
  if ((_response$aggregation3 = response.aggregations) !== null && _response$aggregation3 !== void 0 && _response$aggregation3.datasets.after_key) {
    var _response$aggregation4, _response$aggregation5;
    return getMalformedDocsPaginated({
      esClient,
      type,
      start,
      end,
      datasetQuery,
      after: {
        dataset: (_response$aggregation4 = response.aggregations) === null || _response$aggregation4 === void 0 ? void 0 : _response$aggregation4.datasets.after_key.dataset,
        namespace: (_response$aggregation5 = response.aggregations) === null || _response$aggregation5 === void 0 ? void 0 : _response$aggregation5.datasets.after_key.namespace
      },
      prevResults: malformedDocs
    });
  }
  return malformedDocs;
}