"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamsStatsClient = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _lodash = require("lodash");
var _api_types = require("../../../common/api_types");
var _data_streams_stats = require("../../../common/data_streams_stats");
var _data_stream_stat = require("../../../common/data_streams_stats/data_stream_stat");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataStreamsStatsClient {
  constructor(http) {
    this.http = http;
  }
  async getDataStreamsStats(params = {
    type: 'logs'
  }) {
    const response = await this.http.get('/internal/dataset_quality/data_streams/stats', {
      query: params
    }).catch(error => {
      throw new _data_streams_stats.GetDataStreamsStatsError(`Failed to fetch data streams stats": ${error}`);
    });
    const {
      dataStreamsStats,
      integrations
    } = (0, _ioTsUtils.decodeOrThrow)(_api_types.getDataStreamsStatsResponseRt, message => new _data_streams_stats.GetDataStreamsStatsError(`Failed to decode data streams stats response: ${message}"`))(response);
    const mergedDataStreamsStats = dataStreamsStats.map(statsItem => {
      const integration = (0, _lodash.find)(integrations, {
        name: statsItem.integration
      });
      return (0, _lodash.merge)({}, statsItem, {
        integration
      });
    });
    return mergedDataStreamsStats.map(_data_stream_stat.DataStreamStat.create);
  }
  async getDataStreamsMalformedStats(params) {
    const response = await this.http.get('/internal/dataset_quality/data_streams/malformed_docs', {
      query: {
        ...params,
        type: 'logs'
      }
    }).catch(error => {
      throw new _data_streams_stats.GetDataStreamsStatsError(`Failed to fetch data streams malformed stats": ${error}`);
    });
    const {
      malformedDocs
    } = (0, _ioTsUtils.decodeOrThrow)(_api_types.getDataStreamsMalformedDocsStatsResponseRt, message => new _data_streams_stats.GetDataStreamsStatsError(`Failed to decode data streams malformed docs stats response: ${message}"`))(response);
    return malformedDocs;
  }
}
exports.DataStreamsStatsClient = DataStreamsStatsClient;