"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = Header;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _translations = require("../../../common/translations");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Header() {
  const {
    services: {
      share
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const OnboardingLink = /*#__PURE__*/_react.default.memo(() => {
    const locator = share.url.locators.get(_deeplinksObservability.OBSERVABILITY_ONBOARDING_LOCATOR);
    const onboardingUrl = locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl({});
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: onboardingUrl,
      fill: true,
      size: "s",
      iconType: "indexOpen",
      "data-test-subj": "datasetQualityOnboardingLink"
    }, _translations.onboardingLinkTitle);
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    bottomBorder: true,
    pageTitle: _translations.datasetQualityAppTitle,
    rightSideItems: [/*#__PURE__*/_react.default.createElement(OnboardingLink, null)]
  });
}