"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FileDataVisualizer = void 0;
require("../_index.scss");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _kibana_services = require("../../kibana_services");
var _file_data_visualizer_view = require("./components/file_data_visualizer_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-ignore

const FileDataVisualizer = ({
  getAdditionalLinks
}) => {
  const coreStart = (0, _kibana_services.getCoreStart)();
  const {
    data,
    maps,
    embeddable,
    discover,
    share,
    security,
    fileUpload,
    cloud
  } = (0, _kibana_services.getPluginsStart)();
  const services = {
    data,
    maps,
    embeddable,
    discover,
    share,
    security,
    fileUpload,
    ...coreStart
  };
  const EmptyContext = ({
    children
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  const CloudContext = (cloud === null || cloud === void 0 ? void 0 : cloud.CloudContextProvider) || EmptyContext;
  return /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: coreStart.theme.theme$
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...services
    }
  }, /*#__PURE__*/_react.default.createElement(CloudContext, null, /*#__PURE__*/_react.default.createElement(_file_data_visualizer_view.FileDataVisualizerView, {
    dataViewsContract: data.dataViews,
    http: coreStart.http,
    fileUpload: fileUpload,
    getAdditionalLinks: getAdditionalLinks,
    capabilities: coreStart.application.capabilities
  }))));
};

// exporting as default so it can be used with React.lazy
// eslint-disable-next-line import/no-default-export
exports.FileDataVisualizer = FileDataVisualizer;
var _default = FileDataVisualizer;
exports.default = _default;