"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DistinctValues = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _fieldTypes = require("@kbn/field-types");
var _constants = require("../../../../../../../common/constants");
var _kibana_context = require("../../../../../kibana_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DistinctValues = ({
  showIcon,
  config
}) => {
  const {
    stats,
    type
  } = config;
  const {
    services: {
      data: {
        fieldFormats
      }
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const cardinality = stats === null || stats === void 0 ? void 0 : stats.cardinality;
  if (cardinality === undefined || stats === undefined) return null;
  const {
    sampleCount
  } = stats;
  const tooltipContent = type === _constants.SUPPORTED_FIELD_TYPES.TEXT ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.sampledCardinalityForTextFieldsMsg",
    defaultMessage: "The cardinality for text fields is calculated from a sample of {sampledDocumentsFormatted} {sampledDocuments, plural, one {record} other {records}}.",
    values: {
      sampledDocuments: sampleCount,
      sampledDocumentsFormatted: /*#__PURE__*/_react.default.createElement("strong", null, fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.NUMBER, [_fieldTypes.ES_FIELD_TYPES.INTEGER]).convert(sampleCount))
    }
  }) : null;
  const icon = showIcon ? type === _constants.SUPPORTED_FIELD_TYPES.TEXT ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipContent
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "partial",
    size: 'm',
    className: 'columnHeader__icon'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "database",
    size: 'm',
    className: 'columnHeader__icon'
  }) : null;
  const content = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs'
  }, cardinality);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, icon, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipContent
  }, content));
};
exports.DistinctValues = DistinctValues;