"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColumnChart = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _charts = require("@elastic/charts");
var _mlDataGrid = require("@kbn/ml-data-grid");
require("./column_chart.scss");
var _i18n = require("@kbn/i18n");
var _use_column_chart = require("./use_column_chart");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const zeroSize = {
  bottom: 0,
  left: 0,
  right: 0,
  top: 0
};
const size = {
  width: 100,
  height: 10
};
const ColumnChart = ({
  chartData,
  columnType,
  dataTestSubj,
  hideLabel,
  maxChartColumns,
  isNumeric
}) => {
  const {
    data,
    legendText
  } = (0, _use_column_chart.useColumnChart)(chartData, columnType, maxChartColumns, isNumeric);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj,
    style: {
      width: '100%'
    }
  }, !(0, _mlDataGrid.isUnsupportedChartData)(chartData) && data.length > 0 && /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: size
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    xDomain: Array.from({
      length: maxChartColumns
    }, (_, i) => i),
    theme: {
      chartMargins: zeroSize,
      chartPaddings: zeroSize,
      crosshair: {
        band: {
          visible: false
        }
      }
    },
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: _charts.Position.Bottom,
    tickFormat: idx => {
      var _data$idx$key_as_stri, _data$idx;
      return `${(_data$idx$key_as_stri = (_data$idx = data[idx]) === null || _data$idx === void 0 ? void 0 : _data$idx.key_as_string) !== null && _data$idx$key_as_stri !== void 0 ? _data$idx$key_as_stri : ''}`;
    },
    hide: true
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: 'count',
    xScaleType: _charts.ScaleType.Ordinal,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['doc_count'],
    data: data,
    styleAccessor: d => d.datum.color
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('dataGridChart__legend', {
      'dataGridChart__legend--numeric': columnType.schema === 'number'
    }),
    "data-test-subj": `${dataTestSubj}-legend`
  }, legendText), !hideLabel && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `${dataTestSubj}-id`
  }, columnType.id));
};
exports.ColumnChart = ColumnChart;