"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OtherContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _examples_list = require("../../../examples_list");
var _document_stats = require("./document_stats");
var _expanded_row_content = require("./expanded_row_content");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OtherContent = ({
  config
}) => {
  const {
    stats
  } = config;
  if (stats === undefined) return null;
  return stats.count === undefined ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Array.isArray(stats.examples) && /*#__PURE__*/_react.default.createElement(_examples_list.ExamplesList, {
    examples: stats.examples
  })) : /*#__PURE__*/_react.default.createElement(_expanded_row_content.ExpandedRowContent, {
    dataTestSubj: 'dataVisualizerOtherContent'
  }, /*#__PURE__*/_react.default.createElement(_document_stats.DocumentStatsTable, {
    config: config
  }), Array.isArray(stats.examples) && /*#__PURE__*/_react.default.createElement(_examples_list.ExamplesList, {
    examples: stats.examples
  }));
};
exports.OtherContent = OtherContent;