"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricFieldsCount = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _styles = require("./styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricFieldsCount = ({
  metricsStats
}) => {
  if (!metricsStats || metricsStats.visibleMetricsCount === undefined || metricsStats.totalMetricFieldsCount === undefined) return null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, metricsStats && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: _styles.dvFieldCountItemCss,
    "data-test-subj": "dataVisualizerMetricFieldsSummary",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.searchPanel.numberFieldsLabel",
    defaultMessage: "Number fields"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    color: "subdued",
    size: "m",
    "data-test-subj": "dataVisualizerVisibleMetricFieldsCount"
  }, /*#__PURE__*/_react.default.createElement("strong", null, metricsStats.visibleMetricsCount))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    "data-test-subj": "dataVisualizerMetricFieldsCount"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.searchPanel.ofFieldsTotal",
    defaultMessage: "of {totalCount} total",
    values: {
      totalCount: metricsStats.totalMetricFieldsCount
    }
  })))));
};
exports.MetricFieldsCount = MetricFieldsCount;