"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilebeatConfigFlyout = exports.EDITOR_MODE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _filebeat_config = require("./filebeat_config");
var _kibana_context = require("../../../kibana_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// copy context?
let EDITOR_MODE;
exports.EDITOR_MODE = EDITOR_MODE;
(function (EDITOR_MODE) {
  EDITOR_MODE[EDITOR_MODE["HIDDEN"] = 0] = "HIDDEN";
  EDITOR_MODE[EDITOR_MODE["READONLY"] = 1] = "READONLY";
  EDITOR_MODE[EDITOR_MODE["EDITABLE"] = 2] = "EDITABLE";
})(EDITOR_MODE || (exports.EDITOR_MODE = EDITOR_MODE = {}));
const FilebeatConfigFlyout = ({
  index,
  results,
  ingestPipelineId,
  closeFlyout
}) => {
  const [fileBeatConfig, setFileBeatConfig] = (0, _react.useState)('');
  const [username, setUsername] = (0, _react.useState)(null);
  const {
    services: {
      security
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  (0, _react.useEffect)(() => {
    if (security !== undefined) {
      security.authc.getCurrentUser().then(user => {
        setUsername(user.username === undefined ? null : user.username);
      });
    }
  }, [security]);
  (0, _react.useEffect)(() => {
    const config = (0, _filebeat_config.createFilebeatConfig)(index, results, ingestPipelineId, username);
    setFileBeatConfig(config);
  }, [username, index, ingestPipelineId, results]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout,
    hideCloseButton: true,
    size: 'm',
    ownFocus: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(Contents, {
    value: fileBeatConfig,
    username: username,
    index: index
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: closeFlyout,
    flush: "left",
    "data-test-subj": "fileBeatConfigFlyoutCloseButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.fileBeatConfigFlyout.closeButton",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: fileBeatConfig
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: copy
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.fileBeatConfigFlyout.copyButton",
    defaultMessage: "Copy to clipboard"
  })))))));
};
exports.FilebeatConfigFlyout = FilebeatConfigFlyout;
const Contents = ({
  value,
  index,
  username
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "fileDataVisFilebeatConfigPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.resultsLinks.fileBeatConfigTitle",
    defaultMessage: "Filebeat configuration"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.resultsLinks.fileBeatConfigTopText1",
    defaultMessage: "Additional data can be uploaded to the {index} index using Filebeat.",
    values: {
      index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, index)
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.resultsLinks.fileBeatConfigTopText2",
    defaultMessage: "Modify {filebeatYml} to set the connection information:",
    values: {
      filebeatYml: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "filebeat.yml")
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "bash"
  }, value), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("p", null, username === null ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.resultsLinks.fileBeatConfigBottomTextNoUsername",
    defaultMessage: "Where {esUrl} is the URL of Elasticsearch.",
    values: {
      esUrl: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, '<es_url>')
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.resultsLinks.fileBeatConfigBottomText",
    defaultMessage: "Where {password} is the password of the {user} user, {esUrl} is the URL of Elasticsearch.",
    values: {
      user: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, username),
      password: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, '<password>'),
      esUrl: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, '<es_url>')
    }
  })));
};