"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = registerRoutes;
var _public = require("./rest_api_routes/public");
var _existing_indices = require("./rest_api_routes/internal/existing_indices");
var _fields_for = require("./rest_api_routes/internal/fields_for");
var _has_data_views = require("./rest_api_routes/internal/has_data_views");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function registerRoutes(http, getStartServices, isRollupsEnabled, dataViewRestCounter) {
  const router = http.createRouter();
  _public.routes.forEach(route => route(router, getStartServices, dataViewRestCounter));
  (0, _existing_indices.registerExistingIndicesPath)(router);
  (0, _fields_for.registerFieldForWildcard)(router, getStartServices, isRollupsEnabled);
  (0, _has_data_views.registerHasDataViewsRoute)(router);
}