"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewsPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _expressions = require("./expressions");
var _ = require(".");
var _content_management_wrapper = require("./content_management_wrapper");
var _ui_settings_wrapper = require("./ui_settings_wrapper");
var _data_views_service_public = require("./data_views_service_public");
var _services = require("./services");
var _debounce_by_key = require("./debounce_by_key");
var _constants = require("../common/constants");
var _constants2 = require("../common/content_management/v1/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class DataViewsPublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "hasData", new _services.HasData());
    (0, _defineProperty2.default)(this, "rollupsEnabled", false);
    this.initializerContext = initializerContext;
  }
  setup(core, {
    expressions,
    contentManagement
  }) {
    expressions.registerFunction((0, _expressions.getIndexPatternLoad)({
      getStartServices: core.getStartServices
    }));
    contentManagement.registry.register({
      id: _constants.DATA_VIEW_SAVED_OBJECT_TYPE,
      version: {
        latest: _constants2.LATEST_VERSION
      },
      name: _i18n.i18n.translate('dataViews.contentManagementType', {
        defaultMessage: 'Data view'
      })
    });
    return {
      enableRollups: () => this.rollupsEnabled = true
    };
  }
  start(core, {
    fieldFormats,
    contentManagement
  }) {
    const {
      uiSettings,
      http,
      notifications,
      application
    } = core;
    const onNotifDebounced = (0, _debounce_by_key.debounceByKey)(notifications.toasts.add.bind(notifications.toasts), 10000);
    const onErrorDebounced = (0, _debounce_by_key.debounceByKey)(notifications.toasts.addError.bind(notifications.toasts), 10000);
    const config = this.initializerContext.config.get();
    return new _data_views_service_public.DataViewsServicePublic({
      hasData: this.hasData.start(core),
      uiSettings: new _ui_settings_wrapper.UiSettingsPublicToCommon(uiSettings),
      savedObjectsClient: new _content_management_wrapper.ContentMagementWrapper(contentManagement.client),
      apiClient: new _.DataViewsApiClient(http),
      fieldFormats,
      http,
      onNotification: (toastInputFields, key) => {
        onNotifDebounced(key)(toastInputFields);
      },
      onError: (error, toastInputFields, key) => {
        onErrorDebounced(key)(error, toastInputFields);
      },
      getCanSave: () => Promise.resolve(application.capabilities.indexPatterns.save === true),
      getCanSaveSync: () => application.capabilities.indexPatterns.save === true,
      getCanSaveAdvancedSettings: () => Promise.resolve(application.capabilities.advancedSettings.save === true),
      getIndices: props => (0, _services.getIndices)({
        ...props,
        http: core.http
      }),
      getRollupsEnabled: () => this.rollupsEnabled,
      scriptedFieldsEnabled: config.scriptedFieldsEnabled === false ? false : true // accounting for null value
    });
  }

  stop() {}
}
exports.DataViewsPublicPlugin = DataViewsPublicPlugin;