"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpacesList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-views-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const noun = _i18n.i18n.translate('indexPatternManagement.indexPatternTable.savedObjectName', {
  defaultMessage: 'data view'
});
const SpacesList = ({
  spacesApi,
  capabilities,
  spaceIds,
  id,
  title,
  refresh
}) => {
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  function onClose() {
    setShowFlyout(false);
  }
  const LazySpaceList = spacesApi.ui.components.getSpaceList;
  const LazyShareToSpaceFlyout = spacesApi.ui.components.getShareToSpaceFlyout;
  const shareToSpaceFlyoutProps = {
    savedObjectTarget: {
      type: _public.DATA_VIEW_SAVED_OBJECT_TYPE,
      namespaces: spaceIds,
      id,
      title,
      noun
    },
    onUpdate: refresh,
    onClose
  };
  const canAssignSpaces = !capabilities || !!capabilities.savedObjectsManagement.shareIntoSpace;
  const clickProperties = canAssignSpaces ? {
    cursorStyle: 'pointer',
    listOnClick: () => setShowFlyout(true)
  } : {
    cursorStyle: 'not-allowed'
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(LazySpaceList, (0, _extends2.default)({
    namespaces: spaceIds,
    displayLimit: 8,
    behaviorContext: "outside-space"
  }, clickProperties)), showFlyout && /*#__PURE__*/_react.default.createElement(LazyShareToSpaceFlyout, shareToSpaceFlyoutProps));
};
exports.SpacesList = SpacesList;