"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.removeDataView = void 0;
var _i18n = require("@kbn/i18n");
var _std = require("@kbn/std");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const confirmModalOptionsDelete = {
  confirmButtonText: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.deleteButton', {
    defaultMessage: 'Delete'
  }),
  title: _i18n.i18n.translate('indexPatternManagement.editDataView.deleteHeader', {
    defaultMessage: 'Delete data view'
  }),
  buttonColor: 'danger'
};
const removeDataView = ({
  dataViews,
  overlays,
  onDelete
}) => (dataViewArray, msg) => {
  overlays.openConfirm((0, _public.toMountPoint)(msg), confirmModalOptionsDelete).then(async isConfirmed => {
    if (isConfirmed) {
      await (0, _std.asyncForEach)(dataViewArray, async ({
        id
      }) => dataViews.delete(id));
      onDelete();
    }
  });
};
exports.removeDataView = removeDataView;